<?php

if ( get_theme_mod('show_sidebar_post') ) {
	$sidebar = true;
	$class = '';
} else {
	$sidebar = false;
	$class = 'fl-full-width';
}

get_header();
?>

<div id="fl-content" class="fl-flex fl-container">
	<div id="fl-blogposts" class="<?php echo esc_attr($class); ?>">

		<?php while (have_posts()) :
			the_post();
			$gallery = get_post_meta( $post->ID, '_format_gallery_images', true );
	        $audio = get_post_meta( $post->ID, '_format_audio_embed', true );
	        $video = get_post_meta( $post->ID, '_format_video_embed', true );
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class('fl-article'); ?>>
            <?php $postFormat = get_post_format();
            
            switch ($postFormat) {

                case 'gallery':
                    if ( !empty($gallery) ) {
                        echo '<div class="fl-gallery-slider owl-carousel">';
                            foreach( $gallery as $image ) {
                                echo wp_get_attachment_image( $image, 'tulip_full_thumb' );
                            }
                        echo '</div>';
                    }
                    break;

                case 'audio':
                    if ( !empty($audio) ) {
                        echo '<div class="fl-audio">';
                            echo wp_oembed_get( esc_url($audio) ); 
                        echo '</div>';
                    }
                    break;

                case 'video':
                    if ( !empty($video) ) {
                        echo '<div class="fl-video">';
                            echo wp_oembed_get( esc_url($video) ); 
                        echo '</div>';
                    }
                    break;
                
                default:
                    if ( has_post_thumbnail() ) {
                        echo '<div class="fl-picture">';
                            the_post_thumbnail('tulip_full_thumb');
                        echo '</div>';
                    }
                    break;
            } ?>
            <div class="fl-post-header">
                <h1 class="title"><?php the_title(); ?></h1>

                <span class="fl-meta category"><?php echo the_category(', '); ?></span>

                <?php if ( !get_theme_mod( 'hide_meta_author' ) ) { ?>
                <span class="fl-meta"><?php esc_html_e( 'By ', 'tulip' ); the_author_posts_link(); ?></span>
                <?php } ?>

                <?php if ( !get_theme_mod( 'hide_meta_date' ) ) { ?>
                <span class="fl-meta"><i class="fa fa-calendar-o"></i><?php echo get_the_date('M d, Y'); ?></span>
                <?php } ?>

                <?php if ( !get_theme_mod( 'hide_meta_comments' ) ) {
                    if ( comments_open() || have_comments() ) { ?>
                        <span class="fl-meta"><i class="fa fa-comment-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( esc_html__('No Comments', 'tulip'), esc_html__('1 Comment', 'tulip'), esc_html__( '% Comments', 'tulip') ); ?></a></span>
                    <?php }
                } ?>
            </div>

            <div class="fl-post-content clearfix">               
                <?php
                the_content();
				wp_link_pages('before=<div class="fl-post-pagination">&after=</div>');
                ?>
            </div>

            <div class="fl-article-footer fl-flex">
                <?php
                if( has_tag() && !get_theme_mod( 'hide_meta_tags' ) ) { ?>
                	<div class="tags">
						<?php echo the_tags( '<span class="fl-meta">', ', ', '</span>' ); ?>
					</div>
				<?php } 
                get_template_part( 'includes/sharing' );
                ?>
            </div>

        </article>

		<?php endwhile; ?>

			<!-- About Author -->
			<?php if ( !get_theme_mod( 'author' ) ) { ?>

			<div id="fl-box" class="fl-flex">			
				<div class="avatar">
					<?php echo get_avatar( get_the_author_meta( 'user_email' ), 120 ); ?>
				</div>
				<div class="info">
					<span class="fl-meta"><?php esc_html_e( 'Author', 'tulip' ); ?></span>
					<h4 class="title"><?php the_author_posts_link(); ?></h4>
					<p><?php the_author_meta( 'description' ); ?></p>
					<div class="fl-sharing">

						<?php if ( get_the_author_meta( 'url' ) ) { ?>
							<a href="<?php the_author_meta( 'url' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-globe"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'twitter' ) ) { ?>
							<a href="<?php the_author_meta( 'twitter' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-twitter"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'facebook' ) ) { ?>
							<a href="<?php the_author_meta( 'facebook' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-facebook"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'instagram' ) ) { ?>
							<a href="<?php the_author_meta( 'instagram' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-instagram"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'youtube' ) ) { ?>
							<a href="<?php the_author_meta( 'youtube' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-youtube-play"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'linkedin' ) ) { ?>
							<a href="<?php the_author_meta( 'linkedin' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-linkedin"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'pinterest' ) ) { ?>
							<a href="<?php the_author_meta( 'pinterest' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-pinterest-p"></i>
							</a>
						<?php }

						if ( get_the_author_meta( 'vk' ) ) { ?>
							<a href="<?php the_author_meta( 'vk' ); ?>" target="_blank" rel="nofollow">
								<i class="fa fa-vk"></i>
							</a>
						<?php }	?>

					</div>	
				</div>
			</div>


			

			<?php }

			// Prev/Next Posts
			if ( !get_theme_mod( 'prev_next_posts' ) ) {
				$prev = get_previous_post();
				$next = get_next_post();			
				?>
				<div id="fl-prev-next" class="fl-flex">
					<?php if ( !empty($prev) ) {
						$prevThumb = get_the_post_thumbnail( $prev->ID, 'thumbnail' ); ?>
					<div class="prev item fl-flex">
						<?php if ( !empty($prevThumb) ) {
							echo '<div class="fl-picture">';
							previous_post_link( '%link', $prevThumb );
							echo'</div>';
						} ?>
						<div class="content">
							<span class="fl-meta"><?php esc_html_e( 'Previous Post', 'tulip' ); ?></span>
							<h4 class="title"><?php previous_post_link( '%link', '%title' ); ?></h4>
						</div>
					</div>
					<?php }
					if ( !empty($next) ) {
						$nextThumb = get_the_post_thumbnail( $next->ID, 'thumbnail' ); ?>					
					<div class="next item fl-flex">
						<?php if ( !empty($nextThumb) ) {
							echo '<div class="fl-picture">';
							next_post_link( '%link', $nextThumb );
							echo'</div>';
						} ?>
						<div class="content">
							<span class="fl-meta"><?php esc_html_e( 'Next Post', 'tulip' ); ?></span>
							<h4 class="title"><?php next_post_link( '%link', '%title' ); ?></h4>
						</div>
					</div>
					<?php } ?>
				</div>
			<?php
			}


			// Related Posts
			if ( !get_theme_mod( 'related_posts' ) ) {

				$related = new WP_Query(
				    array(
				        'category__in'   => wp_get_post_categories( $post->ID ),
				        'posts_per_page' => 3,
				        'post__not_in'   => array( $post->ID ),
				        'ignore_sticky_posts' => 1,
				    )
				);

				$thumbs = 0; // Count thumbs
				foreach ($related->posts as $post) {
					if ( has_post_thumbnail( $post->ID ) ) {
						$thumbs++;
					}
					if ( $thumbs > 0 ) break;
				}
				
				if ( $related->have_posts() ) { ?>

					<div id="fl-related" class="fl-flex">
						<h4 class="fl-widget-title"><?php esc_html_e( 'You may also like', 'tulip' ); ?></h4>
					<?php
					while( $related->have_posts() ) {
						$related->the_post(); ?>
							<div class="item fl-flex">
								<?php if ( $thumbs > 0 ) { ?>
			                        <div class="fl-picture">
			                            <a href="<?php the_permalink(); ?>">
			                            	<?php
			                            	the_title();
			                            	if ( has_post_thumbnail() ) {
				                                the_post_thumbnail('tulip_medium_thumb');
				                            } else {
				                            	echo '<img src="'. fl_theme_path . '/img/empty-related.png' .'">';
				                            }
				                            ?>
			                            </a>
			                        </div>
			                    <?php } ?>
			                    <div class="content">
									<h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
									<?php if ( !get_theme_mod( 'hide_meta_author' ) ) { ?>
						                <span class="fl-meta"><?php esc_html_e( 'By ', 'tulip' ); the_author_posts_link(); ?></span>
					                <?php } ?>

					                <?php if ( !get_theme_mod( 'hide_meta_date' ) ) { ?>
						                <span class="fl-meta"><i class="fa fa-calendar-o"></i><?php echo get_the_date('M d, Y'); ?></span>
					                <?php } ?>
				                </div>
							</div>
					<?php }
					wp_reset_postdata();
					?>					
					</div>
				<?php }
			}
		
		// Comments
		comments_template();
		?>
	</div>	
	<?php get_sidebar( null, array( 'display'  => $sidebar ) ); ?>
</div>

<?php get_footer(); ?>