<?php
$header = true;
$footer = true;
$sidebar = false;
$class = 'fl-full-width';

if ( get_theme_mod('show_sidebar_page') ) {
    $sidebar = true;
    $class = '';
}

if ( class_exists( 'WooCommerce' ) ) {
    if ( is_cart() || is_checkout() ) {
        $header = true;
        $footer = false;
        $sidebar = false;
        $class = 'fl-full-width';
    } elseif ( is_account_page() ) {
        $header = false;
        $footer = false;
        $sidebar = false;
        $class = 'fl-full-width';
    }
}


get_header();
?>

<div id="fl-content" class="fl-flex fl-container">
	<div id="fl-blogposts" class="<?php echo esc_attr($class); ?>">

		<?php while (have_posts()) :
			the_post();
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class('fl-article'); ?>>
            <?php if ( $header === true ) {
                if ( has_post_thumbnail() ) {
                    echo '<div class="fl-picture">';
                        the_post_thumbnail('tulip_full_thumb');
                    echo '</div>';
                } ?>
                <div class="fl-post-header">
                    <h1 class="title"><?php the_title(); ?></h1>
                </div>
            <?php } ?>
            <div class="fl-post-content clearfix">               
                <?php
                the_content();
				wp_link_pages('before=<div class="fl-post-pagination">&after=</div>');
                ?>
            </div>
            <?php if ( $footer === true ) { ?>
                <div class="fl-article-footer fl-flex">
                    <?php get_template_part( 'includes/sharing' ); ?>
                </div>
            <?php } ?>

        </article>

		<?php endwhile;
		
		// Comments
		comments_template();
		?>
	</div>	
	<?php get_sidebar( null, array( 'display'  => $sidebar ) ); ?>
</div>

<?php get_footer(); ?>