jQuery(document).ready(function( $ ) {
	"use strict";

    // Passive Touch
    $.event.special.touchstart = {
        setup: function( _, ns, handle ) {
            this.addEventListener('touchstart', handle, { passive: !ns.includes('noPreventDefault') });
        }
    };

    // Dark Switch
    $('#fl-darkmode').change(function() {
        var theme = 'light';

        if ( $(this).is(':checked') ) {
            document.documentElement.setAttribute('data-theme', 'dark');
            theme = 'dark';
        } else {
            document.documentElement.setAttribute('data-theme', 'light');
        }
        document.cookie = 'tulip_color_theme=' + theme + '; path=/; SameSite=None; Secure';
    });

    // RTL Check
    var rtlVal = false;
    if ( $('body').hasClass('rtl') ) {
        rtlVal = true;
    }    

    // Search Slide
    $('#fl-top-bar .search-icon').click(function () {

        if ( $('#fl-top-bar .search').hasClass('active') ) {
            setTimeout( function(){ $('#fl-top-bar .search').removeClass('active'); }, 200 );          
            $('#fl-top-bar .search-input').blur();

            $('#fl-top-bar').animate({scrollLeft: 0 });

        } else {
			$('#fl-top-bar .search').addClass('active');
            $('#fl-top-bar .search-input').delay(200).focus();

            if ( rtlVal == true ) {                
                $('#fl-top-bar').animate({scrollLeft: ( $('#fl-top-bar .search').position().left + $('#fl-top-bar').scrollLeft() - 16 ) });
            } else {
                $('#fl-top-bar').animate({scrollLeft: -1 *( $('#fl-top-bar').width() - $('#fl-top-bar .search').position().left - $('#fl-top-bar .search').width() - $('#fl-top-bar').scrollLeft() ) });
            }
        }
    });
	
    // Mobile Menu icon
	$('#fl-mobile-menu span').click(function() {
		$('#fl-navigation').slideToggle(200);
        $('#fl-navigation').css( 'top', $('header').height() );
	});

    // Mobile submenu
    $('.menu-item-has-children .arrow').click(function () {
        $(this).next('.sub-menu').slideToggle(200);
        $(this).toggleClass('rotate');
    });

	// Featured Posts Slider
	$('.fl-featured').owlCarousel({
		items: 1,
        loop: true,
        nav: false,
        rtl: rtlVal,
        autoplay: true,
        dotsData: true,
        autoplayHoverPause: true,
	});

    // Gallery Post Slider
    $('.fl-gallery-slider').owlCarousel({
        items: 1,
        loop: true,
        nav: true,
        rtl: rtlVal,
        dots: false,
        autoplay: true,
        autoplayHoverPause: true,
    });

	// FitVids
    $('body').fitVids();


    // Masonry
    if ( $('.fl-masonry').length > 0 ) {
        var masonry = new Masonry('.fl-masonry', {
            itemSelector: '.fl-post.grid',
            percentPosition: true,
            horizontalOrder: true,
            transitionDuration: '0.2s',
            gutter: '.fl-masonry-gutter',
        });
    }

    //Read More color
    $('.fl-read-more').hover(
        function() {
            $(this).parent().addClass('active');
        },
        function() {
            $(this).parent().removeClass('active');
        }
    );    
});