<?php

    if ( have_posts() ) :
        while ( have_posts() ) :
            the_post();

            $gallery = get_post_meta( $post->ID, '_format_gallery_images', true );
            $audio = get_post_meta( $post->ID, '_format_audio_embed', true );
            $video = get_post_meta( $post->ID, '_format_video_embed', true );

            $currentPost = $wp_query->current_post;
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

            switch ($args['layout']) {

                case 'bricks_sidebar':
                case 'bricks':
                    if ( $currentPost % 3 == 0 || $currentPost == 0 ) {
                        $thmbnail_size = 'tulip_full_thumb';
                        $articleClass = 'fl-full-width';
                    } else {
                        $thmbnail_size = 'tulip_medium_thumb';
                        $articleClass = 'grid';
                    }
                    break;

                case 'bricks_col_3':
                    if ( $currentPost % 4 == 0 || $currentPost == 0 ) {
                        $thmbnail_size = 'tulip_full_thumb';
                        $articleClass = 'fl-full-width';
                    } else {
                        $thmbnail_size = 'tulip_medium_thumb';
                        $articleClass = 'grid col_3';
                    }
                    break;

                case 'bricks_col_2_3':
                    $thmbnail_size = 'tulip_medium_thumb';
                    if ( ($currentPost ) % 5 == 0 || ($currentPost- 1) % 5 == 0 || $currentPost == 0 || $currentPost == 1 ) {
                        $articleClass = 'grid';
                    } else {
                        $articleClass = 'grid col_3';
                    }
                    break;

                case 'grid_sidebar':
                case 'grid':
                    $thmbnail_size = 'tulip_medium_thumb';
                    $articleClass = 'grid';
                    break;

                case 'grid_col_3':
                    $thmbnail_size = 'tulip_medium_thumb';
                    $articleClass = 'grid col_3';
                    break;

                case 'masonry_sidebar':
                case 'masonry':
                    $thmbnail_size = 'tulip_masonry_thumb';
                    $articleClass = 'grid';
                    break;

                case 'masonry_col_3':
                    $thmbnail_size = 'tulip_masonry_thumb';
                    $articleClass = 'grid col_3';
                    break;

                case 'post_grid_sidebar':
                case 'post_grid':
                    if ( $currentPost == 0 && $paged == 1 ) {
                        $thmbnail_size = 'tulip_full_thumb';
                        $articleClass = 'fl-full-width';
                    } else {
                        $thmbnail_size = 'tulip_medium_thumb';
                        $articleClass = 'grid';
                    }
                    break;

                case 'post_grid_col_3':
                    if ( $currentPost == 0 && $paged == 1 ) {
                        $thmbnail_size = 'tulip_full_thumb';
                        $articleClass = 'fl-full-width';
                    } else {
                        $thmbnail_size = 'tulip_medium_thumb';
                        $articleClass = 'grid col_3';
                    }
                    break;
                
                default:
                    $thmbnail_size = 'tulip_full_thumb';
                    $articleClass = '';
                    break;
            }

            ?>

            <article id="post-<?php the_ID(); ?>" <?php post_class('fl-post '.$articleClass); ?>>

                <?php
                if ( has_post_thumbnail() ) {
                    echo '<div class="fl-picture">';
                        echo '<a href="'. get_the_permalink() .'">';
                            the_title();
                            the_post_thumbnail($thmbnail_size);
                        echo '</a>';
                    echo '</div>';
                }
                ?>

                <div class="fl-post-header">
                    <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <div class="fl-meta-wrap">
                        <span class="fl-meta category"><?php echo the_category(', '); ?></span>

                        <?php if ( !get_theme_mod( 'hide_meta_author' ) ) { ?>
                        <span class="fl-meta"><?php esc_html_e( 'By ', 'tulip' ); the_author_posts_link(); ?></span>
                        <?php } ?>

                        <?php if ( !get_theme_mod( 'hide_meta_date' ) ) { ?>
                        <span class="fl-meta"><i class="fa fa-calendar-o"></i><?php echo get_the_date('M d, Y'); ?></span>
                        <?php } ?>

                        <?php if ( !get_theme_mod( 'hide_meta_comments' ) ) {
                            if ( comments_open() || have_comments() ) { ?>
                                <span class="fl-meta"><i class="fa fa-comment-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( esc_html__('No Comments', 'tulip'), esc_html__('1 Comment', 'tulip'), esc_html__( '% Comments', 'tulip') ); ?></a></span>
                            <?php }
                        } ?>
                    </div>
                </div>

                <div class="fl-post-excerpt">               
                    <?php the_excerpt(); ?>
                </div>

                <div class="fl-article-footer fl-flex">
                    <?php echo '<a class="fl-read-more button" href="' . get_permalink() . '">'. esc_html__( 'Continue Reading', 'tulip' ).'</a>';
                    get_template_part( 'includes/sharing' );
                    ?>
                </div>

            </article>
        <?php endwhile;
    else : ?>
        <article class="fl-full-width">
            <p><?php esc_html_e( 'Sorry, no posts were found', 'tulip' ); ?></p>
        </article>
    <?php endif;
?>