<?php

// Posts Ids
$posts_ids = get_theme_mod('slider_posts');
$Ids = str_replace(' ', '', $posts_ids);
$array_ids = explode(',',$Ids);

// Cats Slugs
$posts_cats = get_theme_mod('slider_cats');
$Cats = str_replace(' ', '', $posts_cats);
$array_cats = explode(',',$Cats);

// Slider number
$slider_num = get_theme_mod('slider_num', 5);

$posts_loop = new WP_Query(
    array(
        'post_type'           => 'post',  
        'post_status'         => 'publish',
        'post__in'            => $array_ids, //Posts
        'meta_key'            => '_thumbnail_id', //Must has thumbnail
        'ignore_sticky_posts' => 1,  
        'posts_per_page'      => $slider_num, // Posts Number    
    )
);


// Cats loop number of posts
if ( !empty($slider_num) ) {
    $cats_num = $slider_num - $posts_loop->found_posts;
} else {
    $cats_num = 0;
}

if ( $cats_num > 0 ) {

    $cats_loop = new WP_Query(
        array(
            'post_type'           => 'post',  
            'post_status'         => 'publish',
            'post__not_in'        => $array_ids, //Ignore Posts loop
            'tax_query'           => array(
                array(
                    'taxonomy' => 'category',
                    'field'    => 'slug',
                    'terms'    => $array_cats //Cats
                )
            ),
            'meta_key'            => '_thumbnail_id', //Must has thumbnail
            'ignore_sticky_posts' => 1,
            'posts_per_page'      => $cats_num, // Posts Number        
        )
    );

}

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$count = $posts_loop->found_posts + $cats_loop->found_posts;

if ( $paged == 1 ) {

    if ( !get_theme_mod('hide_slider') &&  $count > 0 ) { ?>
        <div class="fl-featured <?php if($count > 1) { echo 'multi'; } ?> owl-carousel">
            <?php
            // Posts Loop
            if ( $posts_loop->have_posts() ) {
                while( $posts_loop->have_posts() ) {
                    $posts_loop->the_post();
                    if( has_post_thumbnail () ) {
                        $thumbnail =  wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'tulip_full_thumb');
                        $thumbnail = $thumbnail[0];
                        ?>
                    <div class="post" style="background-image: url(<?php echo esc_url($thumbnail); ?>);" data-dot="<span><?php the_title(); ?></span>">
                        <div class="slide-content">
                            <span class="category"><?php echo the_category(', '); ?>  |  <?php echo get_the_date('M d, Y'); ?></span>
                            <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <a class="more" href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                    <span><?php esc_html_e( 'Read More', 'tulip' ); ?></span>
                                </a>
                        </div>
                    </div>
                    <?php
                    }
                }
                wp_reset_postdata();
            }

            // Cats Loop
            if ( ($cats_num > 0) && $cats_loop->have_posts() ) {
                while( $cats_loop->have_posts() ) {
                    $cats_loop->the_post();
                    if ( has_post_thumbnail () ) {
                        $thumbnail =  wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ),'tulip_full_thumb');
                        $thumbnail = $thumbnail[0];
                        ?>
                    <div class="post" style="background-image: url(<?php echo esc_url($thumbnail); ?>);" data-dot="<span><?php the_title(); ?></span>">
                        <div class="slide-content">
                            <span class="category"><?php echo the_category(', '); ?>  |  <?php echo get_the_date('M d, Y'); ?></span>
                            <h2 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <a class="more" href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                    <span><?php esc_html_e( 'Read More', 'tulip' ); ?></span>
                                </a>
                        </div>
                    </div>
                    <?php
                    }
                }
                wp_reset_postdata();
            }
            ?>
        </div>
    <?php
    } // end the featured posts


    if ( !get_theme_mod('hide_banners') ) {
        if ( get_theme_mod('banner_one_bg', fl_theme_path.'/img/banner.jpg') || get_theme_mod('banner_two_bg', fl_theme_path.'/img/banner.jpg') ) { ?>
            <div class="fl-banners fl-flex">
                <?php if ( get_theme_mod( 'banner_one_bg', fl_theme_path.'/img/banner.jpg' ) ) { ?>
                    <div class="banner" style="background-image: url(<?php echo esc_url( get_theme_mod('banner_one_bg', fl_theme_path.'/img/banner.jpg') ); ?>);">
                        <a href="<?php echo esc_url( get_theme_mod('banner_one_link', '#') ); ?>"><?php echo esc_html( get_theme_mod('banner_one_title', 'Banner one') ); ?></a>        
                        <h3><?php echo esc_html( get_theme_mod('banner_one_title', 'Banner One') ); ?></h3>        
                    </div>
                <?php }

                if ( get_theme_mod('banner_two_bg', fl_theme_path.'/img/banner.jpg') ) { ?>
                    <div class="banner" style="background-image: url(<?php echo esc_url( get_theme_mod('banner_two_bg', fl_theme_path.'/img/banner.jpg') ); ?>);">
                        <a href="<?php echo esc_url( get_theme_mod('banner_two_link', '#') ); ?>"><?php echo esc_html( get_theme_mod('banner_two_title', 'Banner Two') ); ?></a>        
                        <h3><?php echo esc_html( get_theme_mod('banner_two_title', 'Banner Two') ); ?></h3>        
                    </div>
                <?php } ?>
            </div>
        <?php }
    }
} ?>