<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<!-- Mobile Specific Metas -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5">

	<?php wp_head(); ?>

</head>
<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<div id="fl-blog-container">
		
		<!-- Header -->
		<header id="fl-header">
			<div class="fl-flex fl-container">
			    <div id="fl-logo">
				    <?php

				    $logo_src = get_theme_mod('logo', fl_theme_path.'/img/logo.png');

				    if ( !empty($logo_src) ) { ?>
				        <a href='<?php echo esc_url( home_url('/') ); ?>' title='<?php echo esc_attr( get_bloginfo('name', 'display') ); ?>' rel='home'>

				        	<?php
				        	// Light logo				        	
							$logo_id = attachment_url_to_postid($logo_src);

							if ( $logo_id != 0 ) {
								$logo_attr = wp_get_attachment_image_src($logo_id, 'full');
								$logo_width = $logo_attr[1];
								$logo_height = $logo_attr[2];
							} else {
								$logo_width = '500';
								$logo_height = '280';
							}

				        	echo '<img class="light-logo" src="'. esc_url($logo_src) .'" alt="'. esc_attr( get_bloginfo('name', 'display') ) .'" width="'. esc_attr($logo_width) .'" height="'. esc_attr($logo_height) .'">';

							// Dark Logo
							$logo_dark_src = get_theme_mod('logo_dark', fl_theme_path.'/img/logo-dark.png');

				        	if ( !get_theme_mod( 'dark_mode' ) && !empty($logo_dark_src) ) {

				        		$logo_dark_id = attachment_url_to_postid($logo_dark_src);

								if ( $logo_dark_id != 0 ) {
									$logo_dark_attr = wp_get_attachment_image_src($logo_dark_id, 'full');
									$logo_dark_width = $logo_dark_attr[1];
									$logo_dark_height = $logo_dark_attr[2];
								} else {
									$logo_dark_width = '500';
									$logo_dark_height = '280';
								}

					        	echo '<img class="dark-logo" src="'. esc_url($logo_dark_src) .'" alt="'. esc_attr( get_bloginfo('name', 'display') ) .'" width="'. esc_attr($logo_dark_width) .'" height="'. esc_attr($logo_dark_height) .'">';
					        }

					        ?>
				        </a>
					<?php } else {
						if ( is_home() ) {
							echo '<h1><a href="'. esc_url(home_url('/')).'" title="'. get_bloginfo('name') .'" rel="Home">'. get_bloginfo('name') .'</a></h1>';
						} else {
							echo '<p><a href="'. esc_url(home_url('/')).'" title="'. get_bloginfo('name') .'" rel="Home">'. get_bloginfo('name') .'</a></p>';
						} ?>
				        <span><?php bloginfo('description'); ?></span>
					<?php } ?>
				</div>
				<div id="fl-navigation" class="fl-flex">
					<div id="fl-top-bar">

						<?php if ( class_exists( 'WooCommerce' ) ) {

							if ( !get_theme_mod( 'header_cart' ) ) { ?>
					            <a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'tulip' ); ?>">
						            <i class="fa fa-shopping-cart"></i>
						            <?php if ( WC()->cart->get_cart_contents_count() != 0 ) { ?>
							            <span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
						            <?php } ?>
						        </a>
						    <?php }

						    if ( !get_theme_mod( 'header_account' ) ) { ?>
						        <a class="my-account" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php esc_attr_e('My Account','tulip'); ?>">
						        	<i class="fa fa-user-circle-o"></i>
						        </a>
					    <?php }

						}

					    if ( !get_theme_mod( 'dark_mode' ) ) { ?>
						    <label class="fl-theme-switch" for="fl-darkmode">
						        <input type="checkbox" id="fl-darkmode">
						        <div class="slider"></div>
							</label>
						<?php }

						if ( !get_theme_mod( 'header_search' ) ) { ?>	
							<div class="search">
								<div class="search-icon">
									<i class="fa fa-search"></i>
									<i class="fa fa-times"></i>
								</div>
								<?php get_template_part( 'searchform' ); ?>
							</div>
						<?php }

						if ( !get_theme_mod( 'header_social' ) ) {
							get_template_part( 'includes/social-icons' ); 
						} ?>
					</div>
					<div id="fl-header-menu">						
						<?php wp_nav_menu( array( 'theme_location' => 'main-menu' ) ); ?>						
					</div>
				</div>
				<div id="fl-mobile-menu">
					<span>
						<?php esc_html_e( 'Menu', 'tulip' ); ?>
						<i class="fa fa-navicon fa-lg"></i>
					</span>
				</div>
			</div>
		</header>