<?php

// FlatLayers Tulip WooCommerce Functions
function tulip_enqueue_woocommerce_style(){
    wp_enqueue_style( 'tulip-woocommerce-style', fl_theme_path . '/css/woocommerce.css', array('woocommerce-general', 'tulip-style'), fl_theme_version );

    if ( is_rtl() ) {
        wp_enqueue_style( 'tulip-woocommerce-rtl-style', fl_theme_path . '/css/woocommerce-rtl.css', array('woocommerce-general', 'tulip-style', 'tulip-woocommerce-style'), fl_theme_version );
    }
}
add_action( 'wp_enqueue_scripts', 'tulip_enqueue_woocommerce_style' );


/* ====== Remove Content Wrappers ====== */
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper');
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end');


/* ====== Change Main Content Wrapper Start ====== */
function tulip_woocommerce_before_wrapper() {

    // Remove Breadcrumbs brfore main content in Home and single product
    if ( is_home() || is_product() ) {    
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
    }

    if ( is_product() ) {
        if ( get_theme_mod('show_sidebar_product') ) {
            $class = '';
        } else {
           $class = 'fl-full-width'; 
        }

    } else {

        if ( get_theme_mod('shop_layout', 'grid_sidebar') === 'grid_sidebar' ) {
            $class = '';
        } else {
            $class = 'fl-full-width';
        }
    }

    ?>
    <div id="fl-content" class="fl-flex fl-container">
        <div id="fl-blogposts" class="fl-flex <?php echo esc_attr($class); ?>">
    <?php

    // Open Archive Shop Wrap
    if ( !is_product() ) {
        echo '<div id="fl-box" class="fl-flex">';
            if ( is_product_category() ) {
                $cat = get_queried_object();
                $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true );
                $image = wp_get_attachment_image_src( $thumbnail_id, 'thumbnail' );
                if ( !empty($image) ) {
                    echo '<div class="avatar">';
                        echo '<img loading="lazy" src="'. esc_url( $image[0] ) .'" alt="' . esc_attr( $cat->name ) . '">';
                    echo'</div>';
                }
            }
            echo'<div class="info">';
    }
}
add_action('woocommerce_before_main_content', 'tulip_woocommerce_before_wrapper');


/* ====== Change Main Content Wrapper End ====== */
function tulip_woocommerce_after_wrapper() {

        if ( is_product() ) {
            if ( get_theme_mod('show_sidebar_product') ) {
                $sidebar = true;
            } else {
               $sidebar = false;
            }

        } else {

            if ( get_theme_mod('shop_layout', 'grid_sidebar') === 'grid_sidebar' ) {
                $sidebar = true;
            } else {
                $sidebar = false;
            }
        }
        
        echo '</div>';
        get_sidebar( null, array( 'display'  => $sidebar ) );
    echo '</div>';
}
add_action('woocommerce_after_main_content', 'tulip_woocommerce_after_wrapper');



/* ====== Close Archive Shop Wrap ====== */
function tulip_woocommerce_after_archive() {
    // Close Archive Shop Wrap
    if ( !is_product() ) {
            echo '</div>';
        echo '</div>';
    }
}
add_action('woocommerce_archive_description', 'tulip_woocommerce_after_archive');


/* ====== Change Products Columns ====== */
function tulip_woocommerce_loop_columns() {  
    if ( get_theme_mod('shop_layout', 'grid_sidebar') == 'grid_sidebar' ) {
        return 2; // 2 products per row with sidebar
    } else {
        return 3; // 3 products per row without sidebar
    }
}
add_filter('loop_shop_columns', 'tulip_woocommerce_loop_columns');

/* ====== Ajax update cart icon ====== */
function tulip_woocommerce_header_add_to_cart_fragment( $fragments ) {
    ob_start();
    ?>
    <a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'tulip' ); ?>">
        <i class="fa fa-shopping-cart"></i>                             
        <?php if ( WC()->cart->get_cart_contents_count() != 0 ) { ?>
            <span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
        <?php } ?>
    </a>
    <?php
    
    $fragments['a.cart-contents'] = ob_get_clean();
    
    return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'tulip_woocommerce_header_add_to_cart_fragment' );


/* ====== Add Breadcurmb to Single Product Page ====== */
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 0, 0);


function tulip_woocommerce_product_sharing() {
    echo '<div class="fl-article-footer fl-flex">';
        get_template_part( 'includes/sharing' );
    echo '</div>';
}

// Right column - sharing
add_action( 'woocommerce_after_single_product_summary', 'tulip_woocommerce_product_sharing');