<?php

/*	
*	Tulip Customizer
*	---------------------
*/


function tulip_customizer( $wp_customize ) {
// Settings, Sections, and Controls are defined here

	$layouts = array(
		'bricks'            => esc_html__( 'Bricks (1/2)', 'tulip' ),
		'bricks_col_3'      => esc_html__( 'Bricks (1/3)', 'tulip' ),
		'bricks_col_2_3'    => esc_html__( 'Bricks (2/3)', 'tulip' ),
		'bricks_sidebar'    => esc_html__( 'Bricks & Sidebar', 'tulip' ),
		'post_grid'         => esc_html__( 'First Full Post Then Grid 2 Columns', 'tulip' ),
		'post_grid_col_3'   => esc_html__( 'First Full Post Then Grid 3 Columns', 'tulip' ),
		'post_grid_sidebar' => esc_html__( 'First Full Post Then Grid & Sidebar', 'tulip' ),
		'grid'              => esc_html__( 'Grid 2 Columns', 'tulip' ),		
		'grid_col_3'        => esc_html__( 'Grid 3 Columns', 'tulip' ),
		'grid_sidebar'      => esc_html__( 'Grid & Sidebar', 'tulip' ),
		'masonry'           => esc_html__( 'Masonry 2 Columns', 'tulip' ),		
		'masonry_col_3'     => esc_html__( 'Masonry 3 Columns', 'tulip' ),
		'masonry_sidebar'   => esc_html__( 'Masonry & Sidebar', 'tulip' ),
		'standard'          => esc_html__( 'Standard', 'tulip' ),
		'standard_sidebar'  => esc_html__( 'Standard & Sidebar', 'tulip' ),
	);

	// General Settings Section
	$wp_customize->add_section( 'general_settings' , array(
	    'title'       => esc_html__( 'General Settings', 'tulip' ),
	    'priority'    => 30,
	) );

		// Sidebar Position
		$wp_customize->add_setting( 'sidebar_position', array(
	        'default'  => 'right',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'sidebar_position', array(
	    	'type'     => 'select',
	        'label'    => esc_html__( 'Sidebar Position', 'tulip' ),
	        'section'  => 'general_settings',
	        'priority' => 1,
	        'choices'  => array(
	        	'right' => 'Right',
	        	'left' => 'Left',
		        ),
        ) );

        // Disable Sticky Sidebar
		$wp_customize->add_setting( 'disable_sticky_sidebar', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'disable_sticky_sidebar', array(
			'label'    => esc_html__( 'Disable Sticky Sidebar', 'tulip' ),
			'section'  => 'general_settings',
			'type'     => 'checkbox',
			'priority' => 2,
		) );

        // Show Sidebar in Posts
		$wp_customize->add_setting( 'show_sidebar_post', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'show_sidebar_post', array(
			'label'    => esc_html__( 'Show sidebar in posts', 'tulip' ),
			'section'  => 'general_settings',
			'type'     => 'checkbox',
			'priority' => 3,
		) );

		// Show Sidebar in Pages
		$wp_customize->add_setting( 'show_sidebar_page', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'show_sidebar_page', array(
			'label'    => esc_html__( 'Show sidebar in pages', 'tulip' ),
			'section'  => 'general_settings',
			'type'     => 'checkbox',
			'priority' => 4,
		) );

		// Blog layout
		$wp_customize->add_setting( 'blog_layout', array(
			'default'           => 'bricks_sidebar',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'blog_layout', array(
			'type'     => 'select',
			'label'    => esc_html__( 'Blog Layout', 'tulip' ),
			'section'  => 'general_settings',			
			'priority' => 5,
			'choices'  => $layouts,
        ) );


        // Category Archive layout
		$wp_customize->add_setting( 'category_layout', array(
			'default'           => 'post_grid_sidebar',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'category_layout', array(
			'type'     => 'select',
			'label'    => esc_html__( 'Categories Archive Layout', 'tulip' ),
			'section'  => 'general_settings',			
			'priority' => 6,
			'choices'  => $layouts,
        ) );


        // Author layout
		$wp_customize->add_setting( 'author_layout', array(
			'default'           => 'grid_sidebar',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'author_layout', array(
			'type'     => 'select',
			'label'    => esc_html__( 'Author Archive Layout', 'tulip' ),
			'section'  => 'general_settings',
			'priority' => 7,
			'choices'  => $layouts,
        ) );


        // Search layout
		$wp_customize->add_setting( 'search_layout', array(
			'default'           => 'grid_sidebar',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'search_layout', array(
			'type'     => 'select',
			'label'    => esc_html__( 'Search Results Layout', 'tulip' ),
			'section'  => 'general_settings',
			'priority' => 8,
			'choices'  => $layouts,
        ) );

        // Other Archive layout
		$wp_customize->add_setting( 'archive_layout', array(
			'default'           => 'grid_sidebar',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'archive_layout', array(
			'type'     => 'select',
			'label'    => esc_html__( 'Tags & Other Archives Layout', 'tulip' ),
			'section'  => 'general_settings',
			'priority' => 9,
			'choices'  => $layouts,
        ) );


		// WooCommerce
        if ( class_exists( 'WooCommerce' ) ) {

	        // WooCommerce Shop Layout
			$wp_customize->add_setting( 'shop_layout', array(
				'default'           => 'grid_sidebar',
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'shop_layout', array(
				'type'     => 'select',
				'label'    => esc_html__( 'WooCommerce Shop & Archives Layout', 'tulip' ),
				'section'  => 'general_settings',
				'priority' => 10,
				'choices'  => array(
					'grid_sidebar' => esc_html__( 'Grid 2 Columns & Sidebar', 'tulip' ),
					'grid' => esc_html__( 'Grid 3 Columns', 'tulip' ),
				),
	        ) );

	        // Show Sidebar in Product
			$wp_customize->add_setting( 'show_sidebar_product', array(
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'show_sidebar_product', array(
				'label'    => esc_html__( 'Show sidebar in product page', 'tulip' ),
				'section'  => 'general_settings',
				'type'     => 'checkbox',
				'priority' => 11,
			) );

		}

//.............................. End General Settings Section

// Header Settings Section
	$wp_customize->add_section( 'header_settings' , array(
	    'title'       => esc_html__( 'Header Settings', 'tulip' ),
	    'priority'    => 35,
	) );

		// Disable Dark Mode
		$wp_customize->add_setting( 'dark_mode_default', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'dark_mode_default', array(
			'label'    => esc_html__( 'Set Dark Mode As Default Mode', 'tulip' ),
			'section'  => 'header_settings',
			'type'     => 'checkbox',
			'priority' => 1,
		) );

		// Disable Dark Mode
		$wp_customize->add_setting( 'dark_mode', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'dark_mode', array(
			'label'    => esc_html__( 'Disable Dark Mode', 'tulip' ),
			'section'  => 'header_settings',
			'type'     => 'checkbox',
			'priority' => 2,
		) );

		// Logo
		$wp_customize->add_setting( 'logo', array(
			'default'  => fl_theme_path.'/img/logo.png',
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo', array(
		    'label'    => esc_html__( 'Logo', 'tulip' ),
		    'description' => esc_html__( 'Add logo to display logo and dark mode logo.', 'tulip' ),
		    'section'  => 'header_settings',
		    'priority' => 3,
		) ) );

		// Logo Dark Mode
		$wp_customize->add_setting( 'logo_dark', array(
			'default'  => fl_theme_path.'/img/logo-dark.png',
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo_dark', array(
		    'label'    => esc_html__( 'Dark Mode Logo', 'tulip' ),
		    'section'  => 'header_settings',
		    'priority' => 4,
		) ) );

		// Hide Social Icons
		$wp_customize->add_setting( 'header_social', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'header_social', array(
			'label'    => esc_html__( 'Hide Social Icons', 'tulip' ),
			'section'  => 'header_settings',
			'type'     => 'checkbox',
			'priority' => 5,
		) );

		// Hide Search
		$wp_customize->add_setting( 'header_search', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'header_search', array(
			'label'    => esc_html__( 'Hide Search', 'tulip' ),
			'section'  => 'header_settings',
			'type'     => 'checkbox',
			'priority' => 6,
		) );

		// WooCommerce
        if ( class_exists( 'WooCommerce' ) ) {
        	// Hide Social Icons
			$wp_customize->add_setting( 'header_cart', array(
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'header_cart', array(
				'label'    => esc_html__( 'Hide WooCommerce Cart Icon', 'tulip' ),
				'section'  => 'header_settings',
				'type'     => 'checkbox',
				'priority' => 7,
			) );

			// Hide Search
			$wp_customize->add_setting( 'header_account', array(
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'header_account', array(
				'label'    => esc_html__( 'Hide WooCommerce Account Icon', 'tulip' ),
				'section'  => 'header_settings',
				'type'     => 'checkbox',
				'priority' => 8,
			) );
        }


//.............................. End Header Settings Section


// Featured Slider Section
	$wp_customize->add_section( 'slider_settings' , array(
	    'title'       => esc_html__( 'Featured Posts Slider Settings', 'tulip' ),
	    'description' => esc_html__( 'Display specific posts and/or latest posts from certain categories.', 'tulip' ),
	    'priority'    => 40,
	) );

		// Hide Featured Slider
		$wp_customize->add_setting( 'hide_slider', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_slider', array(
			'label'    => esc_html__( 'Hide Featured Posts Slider', 'tulip' ),
			'section'  => 'slider_settings',
			'type'     => 'checkbox',
			'priority' => 1,
		) );


		// Posts Ids
		$wp_customize->add_setting( 'slider_posts', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'slider_posts', array(
			'label'       => esc_html__( 'Posts IDs', 'tulip' ),
			'description' => esc_html__( 'Split posts IDs by ",". Example: 134,176,176...etc', 'tulip' ),
			'section'     => 'slider_settings',
			'type'        => 'text',
			'priority'    => 2,
		) );

		// Categories Slugs
		$wp_customize->add_setting( 'slider_cats', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'slider_cats', array(
			'label'       => esc_html__( 'Categories Slugs', 'tulip' ),
			'description' => esc_html__( 'Split slugs by ",". Example: cats,dogs,horses...etc.', 'tulip' ),
			'section'     => 'slider_settings',
			'type'        => 'text',
			'priority'    => 3,
		) );


		// Max numnber of posts
		$wp_customize->add_setting( 'slider_num', array(
			'default'           => '5',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'slider_num', array(
			'label'       => esc_html__( 'Maximum Number Of Featured Posts', 'tulip' ),
			'description' => esc_html__( 'Defualt is 5, Minimum is 1, Maximum is 10.', 'tulip' ),
			'section'     => 'slider_settings',
			'type'        => 'range',
			'priority'    => 4,
			'input_attrs' => array(
				'min' => 1,
				'max' => 10,
				'step' => 1,
			),
		) );

// .............................. End Featured Slider Section


// Banners Section
	$wp_customize->add_section( 'banners_settings' , array(
	    'title'       => esc_html__( 'Banners Settings', 'tulip' ),
	    'description' => esc_html__( 'Banners appears under featured posts slider. You can add one banner or two banners. Minimum picture size is 1060x176px for one banner or 510x176px for two banners.', 'tulip' ),
	    'priority'    => 45,
	) );

		// Hide Banners Area
		$wp_customize->add_setting( 'hide_banners', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_banners', array(
			'label'    => esc_html__( 'Hide Banners Section', 'tulip' ),
			'section'  => 'banners_settings',
			'type'     => 'checkbox',
			'priority' => 1,
		) );

		// Banner 1 Background
		$wp_customize->add_setting( 'banner_one_bg', array(
			'default'  => fl_theme_path.'/img/banner.jpg',
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'banner_one_bg', array(
		    'label'    => esc_html__( 'Banner 1 Background', 'tulip' ),
		    'section'  => 'banners_settings',
		    'settings' => 'banner_one_bg',
		    'priority' => 2,
		) ) );

		// Banner 1 Title
        $wp_customize->add_setting( 'banner_one_title', array(
	        'default'  => 'Banner One',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'banner_one_title', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Banner 1 Title', 'tulip' ),
	        'section'  => 'banners_settings',
	        'priority' => 3,
        ) );

        // Banner 1 Link
        $wp_customize->add_setting( 'banner_one_link', array(
	        'default'  => '#',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'banner_one_link', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Banner 1 Link', 'tulip' ),
	        'section'  => 'banners_settings',
	        'priority' => 4,
        ) );

		// Banner 2 Background
		$wp_customize->add_setting( 'banner_two_bg', array(
			'default'  => fl_theme_path.'/img/banner.jpg',
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'banner_two_bg', array(
		    'label'    => esc_html__( 'Banner 2 Background', 'tulip' ),
		    'section'  => 'banners_settings',
		    'settings' => 'banner_two_bg',
		    'priority' => 5,
		) ) );

		// Banner 2 Title
        $wp_customize->add_setting( 'banner_two_title', array(
	        'default'  => 'Banner Two',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'banner_two_title', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Banner 2 Title', 'tulip' ),
	        'section'  => 'banners_settings',
	        'priority' => 6,
        ) );

        // Banner 2 Link
        $wp_customize->add_setting( 'banner_two_link', array(
	        'default'  => '#',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'banner_two_link', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Banner 2 Link', 'tulip' ),
	        'section'  => 'banners_settings',
	        'priority' => 7,
        ) );

// .............................. End Banners Section

// Post Settings Section
	$wp_customize->add_section( 'post_settings' , array(
	    'title'       => esc_html__( 'Post Settings', 'tulip' ),
	    'priority'    => 50,
	) );	

		// Hide Author Section
		$wp_customize->add_setting( 'author', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'author', array(
			'label'    => 'Hide Author Section',
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 1,
		));

		// Hide Next & Previous Posts
		$wp_customize->add_setting( 'prev_next_posts', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'prev_next_posts', array(
			'label'    => esc_html__( 'Hide Previous & Next Posts Section', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 2,
		));

		// Hide Related Posts
		$wp_customize->add_setting( 'related_posts', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'related_posts', array(
			'label'    => esc_html__( 'Hide Related Posts', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 3,
		));

		// Hide Share Icons
		$wp_customize->add_setting( 'share_icons', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'share_icons', array(
			'label'    => esc_html__( 'Hide Share Icons', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 4,
		));

		// Hide Author
		$wp_customize->add_setting( 'hide_meta_author', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_meta_author', array(
			'label'    => esc_html__( 'Hide Author Meta', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 5,
		));

		// Hide Date
		$wp_customize->add_setting( 'hide_meta_date', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_meta_date', array(
			'label'    => esc_html__( 'Hide Date Meta', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 6,
		));

		// Hide Tags
		$wp_customize->add_setting( 'hide_meta_tags', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_meta_tags', array(
			'label'    => esc_html__( 'Hide Tags Meta', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 7,
		));

		// Hide Comments
		$wp_customize->add_setting( 'hide_meta_comments', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'hide_meta_comments', array(
			'label'    => esc_html__( 'Hide Comments Meta', 'tulip' ),
			'section'  => 'post_settings',
			'type'     => 'checkbox',
			'priority' => 8,
		));
		
//.............................. End Post Settings Section

// Footer Settings Section
	$wp_customize->add_section( 'footer_settings' , array(
    'title'       => esc_html__( 'Footer Settings', 'tulip' ),
    'priority'    => 55,
	) );

		// Hide Footer Widgets
		$wp_customize->add_setting( 'footer_widgets', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'footer_widgets', array(
			'label'    => esc_html__( 'Hide Footer Widgets', 'tulip' ),
			'section'  => 'footer_settings',
			'type'     => 'checkbox',
			'priority' => 1,
		));

		// Hide Footer Socials
		$wp_customize->add_setting( 'footer_social', array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'footer_social', array(
			'label'    => esc_html__( 'Hide Footer Socials', 'tulip' ),
			'section'  => 'footer_settings',
			'type'     => 'checkbox',
			'priority' => 2,
		));

		// Copyrights
		$wp_customize->add_setting( 'copyrights', array(
			'default'   => 'Tulip is a Responsive WordPress theme which brings simple and clean design. It’s very flexible, fully customizable by WordPress Customizer. We take care of every detail to create awesome blog for you. It’s a perfect fit for photographers, artists and writers.<br>Made with love at <a href="http://flatlayers.com" target="_blank">FlatLayers</a> | Powered by <a href="http://wordpress.org" target="_blank">WordPress</a>',
			'sanitize_callback' => 'tulip_textarea_sanitize',
		) );

		$wp_customize->add_control( 'copyrights', array(
			'label'     => esc_html__( 'Copyrights', 'tulip' ),
			'section'   => 'footer_settings',
			'type'      => 'textarea',
			'priority'  => 3,
		) );

//.............................. End Footer Settings Section


	// Colors: General
	$wp_customize->add_section( 'colors_general' , array(
	    'title'       => esc_html__( 'Colors: General', 'tulip' ),
	    'priority'    => 60,
	) );

		// Accent Color
		$wp_customize->add_setting( 'accent_color', array(
			'default'  => '#ec7a5c',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'accent_color', array(
			'label'    => esc_html__( 'Accent Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 1,
		) ) );

		// Body Background Color
		$wp_customize->add_setting( 'body_bg', array(
			'default'  => '#ededed',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'body_bg', array(
			'label'    => esc_html__( 'Body Background Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 2,
		) ) );

		// Content Background Color
		$wp_customize->add_setting( 'content_bg', array(
			'default'  => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'content_bg', array(
			'label'    => esc_html__( 'Content Background Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 3,
		) ) );

		// Content Text Color
		$wp_customize->add_setting( 'content_color', array(
			'default' => '#444444',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'content_color', array(
			'label'    => esc_html__( 'Content Text Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 4,
		) ) );


		// Headings Text Color
		$wp_customize->add_setting( 'headings_color', array(
			'default' => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'headings_color', array(
			'label'    => esc_html__( 'Headings Text Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 5,
		) ) );


		// Meta Text Color
		$wp_customize->add_setting( 'meta_color', array(
			'default' => '#888888',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'meta_color', array(
			'label'    => esc_html__( 'Meta Text Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 6,
		) ) );


		// Buttons Background Color
		$wp_customize->add_setting( 'buttons_bg', array(
			'default' => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'buttons_bg', array(
			'label'    => esc_html__( 'Buttons Background Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 7,
		) ) );

		// Archive & Author Box Background Color
		$wp_customize->add_setting( 'box_bg', array(
			'default' => '#f5f5f5',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'box_bg', array(
			'label'    => esc_html__( 'Archive & Author Box Background Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 8,
		) ) );

		// Archive & Author Box Text Color
		$wp_customize->add_setting( 'box_color', array(
			'default' => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'box_color', array(
			'label'    => esc_html__( 'Archive & Author Box Text Color', 'tulip' ),
			'section'  => 'colors_general',
			'priority' => 9,
		) ) );

//.............................. End Colors: General Section


	// Colors: Header
	$wp_customize->add_section( 'colors_header' , array(
	    'title'       => esc_html__( 'Colors: Header', 'tulip' ),
	    'priority'    => 65,
	) );


		// Header Background Color
		$wp_customize->add_setting( 'header_bg', array(
			'default'   => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_bg', array(
			'label'    => esc_html__( 'Header Background Color', 'tulip' ),
			'section'  => 'colors_header',
			'priority' => 1,
		) ) );

		// Header Text Color
		$wp_customize->add_setting( 'header_color', array(
			'default'   => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_color', array(
			'label'    => esc_html__( 'Header Text Color', 'tulip' ),
			'section'  => 'colors_header',
			'priority' => 2,
		) ) );

		// Sub Menu Background Color
		$wp_customize->add_setting( 'submenu_bg', array(
			'default'   => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'submenu_bg', array(
			'label'    => esc_html__( 'Sub Menu Background', 'tulip' ),
			'section'  => 'colors_header',
			'priority' => 3,
		) ) );

		// Sub Menu Text Color
		$wp_customize->add_setting( 'submenu_color', array(
			'default'   => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'submenu_color', array(
			'label'    => esc_html__( 'Sub Menu Text Color', 'tulip' ),
			'section'  => 'colors_header',
			'priority' => 4,
		) ) );
//.............................. End Colors: Header

	// Colors: Footer
	$wp_customize->add_section( 'colors_footer' , array(
	    'title'       => esc_html__( 'Colors: Footer', 'tulip' ),
	    'priority'    => 70,
	) );

		// Footer Background Color
		$wp_customize->add_setting( 'footer_bg', array(
			'default'   => '#f5f5f5',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_bg', array(
			'label'    => esc_html__( 'Footer Background Color', 'tulip' ),
			'section'  => 'colors_footer',
			'priority' => 1,
		) ) );


		// Footer Text Color
		$wp_customize->add_setting( 'footer_color', array(
			'default'   => '#444444',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_color', array(
			'label'    => esc_html__( 'Footer Text Color', 'tulip' ),
			'section'  => 'colors_footer',
			'priority' => 2,
		) ) );


		// Footer Headings Text Color
		$wp_customize->add_setting( 'footer_headings_color', array(
			'default'   => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_headings_color', array(
			'label'    => esc_html__( 'Footer Headings Text Color', 'tulip' ),
			'section'  => 'colors_footer',
			'priority' => 3,
		) ) );



		// Copyright & Social Background Color
		$wp_customize->add_setting( 'copyright_bg', array(
			'default'   => '#121212',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'copyright_bg', array(
			'label'    => esc_html__( 'Copyright & Social Background Color', 'tulip' ),
			'section'  => 'colors_footer',
			'priority' => 4,
		) ) );


		// Copyright & Social Background Color
		$wp_customize->add_setting( 'copyright_color', array(
			'default'   => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		) );

		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'copyright_color', array(
			'label'    => esc_html__( 'Copyright & Social Text Color', 'tulip' ),
			'section'  => 'colors_footer',
			'priority' => 5,
		) ) );
//.............................. End Colors: Footer

	// Typography Section
	$wp_customize->add_section( 'typography' , array(
	    'title'       => esc_html__( 'Typography', 'tulip' ),
	    'priority'    => 75,
	) );

        // Headings Font Family
        $wp_customize->add_setting( 'headings_font', array(
	        'default'  => 'Playfair Display',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'headings_font', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Headings Font Family', 'tulip' ),
	        'description' => esc_html__( 'Got to Google Fonts (https://fonts.google.com). Copy selected font name and paste it here.', 'tulip' ),
	        'section'  => 'typography',
	        'priority' => 1,
        ) );


        // Headings Font Weight
        $wp_customize->add_setting( 'headings_font_weight', array(
	        'default'  => '700',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'headings_font_weight', array(
	    	'type'     => 'select',
	        'label'    => esc_html__( 'Headings Font Weight', 'tulip' ),
	        'section'  => 'typography',
	        'priority' => 2,
	        'choices'  => array(
	        	'400' => 'Normal',
	        	'700' => 'Bold',
	        ),
        ) );

    
		// Content Font Family
        $wp_customize->add_setting( 'body_font', array(
	        'default'  => 'Lora',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'body_font', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Body Font Family', 'tulip' ),
	        'description' => esc_html__( 'Got to Google Fonts (https://fonts.google.com). Copy selected font name and paste it here.', 'tulip' ),
	        'section'  => 'typography',
	        'priority' => 3,
        ) );
        

        // Body Text Font Size
        $wp_customize->add_setting( 'body_font_size', array(
	        'default'  => '14',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'body_font_size', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Body Text Font Size', 'tulip' ),
	        'description' => esc_html__( 'Headings and all other typography elements are based on body font. When you increase body font all other typography elements increase with the same ratio.', 'tulip' ),
	        'section'  => 'typography',
	        'priority' => 4,
        ) );
//.............................. End Typography Section

    // Social Media
	$wp_customize->add_section( 'social' , array(
	    'title'       => esc_html__( 'Social Media (Header & Footer)', 'tulip' ),
	    'priority'    => 80,
		'description' => esc_html__( 'Add social media URLs. Icon will not display if left blank.', 'tulip' ),
	) );

		// Twitter
        $wp_customize->add_setting( 'twitter', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'twitter', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Twitter', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 1,
        ) );

        // Facebook
        $wp_customize->add_setting( 'facebook', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'facebook', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Facebook', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 2,
        ) );

        // Instagram
        $wp_customize->add_setting( 'instagram', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'instagram', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Instagram', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 3,
        ) );

        // Vimeo
        $wp_customize->add_setting( 'vimeo', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'vimeo', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Vimeo', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 4,
        ) );

        // Youtube
        $wp_customize->add_setting( 'youtube', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'youtube', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Youtube', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 5,
        ) );

        // Soundcloud
        $wp_customize->add_setting( 'soundcloud', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'soundcloud', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Soundcloud', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 6,
        ) );

        // Dribbble
        $wp_customize->add_setting( 'dribbble', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'dribbble', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Dribbble', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 7,
        ) );

        // Pinterest
        $wp_customize->add_setting( 'pinterest', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'pinterest', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Pinterest', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 8,
        ) );

        // Linkedin
        $wp_customize->add_setting( 'linkedin', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'linkedin', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Linkedin', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 9,
        ) );

        // VK
        $wp_customize->add_setting( 'vk', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'vk', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'VK', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 10,
        ) );

        // Behance
        $wp_customize->add_setting( 'behance', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'behance', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Behance', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 11,
        ) );

        // Flickr
        $wp_customize->add_setting( 'flickr', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'flickr', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'Flickr', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 12,
        ) );

        // Mail
        $wp_customize->add_setting( 'mail', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'mail', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'E-mail', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 13,
        ) );

        // RSS
        $wp_customize->add_setting( 'rss', array(
	        'default'  => '',
	        'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'rss', array(
	    	'type'     => 'text',
	        'label'    => esc_html__( 'RSS', 'tulip' ),
	        'section'  => 'social',
	        'priority' => 14,
        ) );
//.............................. End Social Media Section

}
add_action( 'customize_register', 'tulip_customizer' );

function tulip_textarea_sanitize( $input ) {
    return wp_kses_post( $input );
}

// Add Changes To Head
function tulip_customizer_output(){ 
	$sidebar_position = get_theme_mod('sidebar_position', 'right');

	// Colors: General
	$accent_color = get_theme_mod('accent_color', '#ec7a5c');
	$body_bg = get_theme_mod('body_bg', '#ededed');
	$content_bg = get_theme_mod('content_bg', '#ffffff');
	$content_color = get_theme_mod('content_color', '#444444');
	$headings_color = get_theme_mod('headings_color', '#121212');
	$meta_color = get_theme_mod('meta_color', '#888888');
	$buttons_bg = get_theme_mod('buttons_bg', '#121212');
	$box_bg = get_theme_mod('box_bg', '#f5f5f5');
	$box_color = get_theme_mod('box_color', '#121212');

	// Colors: Header
	$header_bg = get_theme_mod('header_bg', '#ffffff');
	$header_color = get_theme_mod('header_color', '#121212');
	$submenu_bg = get_theme_mod('submenu_bg', '#ffffff');
	$submenu_color = get_theme_mod('submenu_color', '#121212');

	// Colors: Footer
	$footer_bg = get_theme_mod('footer_bg', '#f5f5f5');
	$footer_color = get_theme_mod('footer_color', '#444444');
	$footer_headings_color = get_theme_mod('footer_headings_color', '#121212');
	$copyright_bg = get_theme_mod('copyright_bg', '#121212');
	$copyright_color = get_theme_mod('copyright_color', '#ffffff');


	// Typography
	$headings_font = get_theme_mod('headings_font', 'Playfair Display');
	$headings_font_weight = get_theme_mod('headings_font_weight', '700');
	$body_font = get_theme_mod('body_font', 'Lora');
	$body_font_size = get_theme_mod('body_font_size', '14');



	//Output
	ob_start();

	if ( $sidebar_position == 'left' && !is_rtl() ) {
		echo '#fl-content { flex-direction: row-reverse; }';
	}

	if ( $sidebar_position == 'right' && is_rtl() ) {
		echo '#fl-content { flex-direction: row-reverse; }';
	}

	if ( get_theme_mod('disable_sticky_sidebar') ) {
		echo '.sticky-sidebar { position: relative; top: auto; }';
	}

	?>

	:root {
		--fl-body-font-size: <?php echo esc_attr($body_font_size).'px'; ?>;
		--fl-body-font: <?php echo '"'.esc_attr($body_font) .'", "Times New Roman", serif'; ?>;
		--fl-headings-font: <?php echo '"'.esc_attr($headings_font) .'", "Times New Roman", serif'; ?>;
		--fl-headings-font-weight: <?php echo esc_attr($headings_font_weight); ?>;

	    --fl-accent-color: <?php echo esc_attr($accent_color); ?>;
	    --fl-body-background: <?php echo esc_attr($body_bg); ?>;
	    --fl-blog-background: <?php echo esc_attr($content_bg); ?>;
	    --fl-body-color: <?php echo esc_attr($content_color); ?>;
	    --fl-headings-color: <?php echo esc_attr($headings_color); ?>;
	    --fl-meta-color: <?php echo esc_attr($meta_color); ?>;
	    --fl-button-background: <?php echo esc_attr($buttons_bg); ?>;
	    --fl-box-background: <?php echo esc_attr($box_bg); ?>;
	    --fl-box-color: <?php echo esc_attr($box_color); ?>;

	    --fl-header-background: <?php echo esc_attr($header_bg); ?>;
	    --fl-header-color: <?php echo esc_attr($header_color); ?>;
	    --fl-submenu-background: <?php echo esc_attr($submenu_bg); ?>;
	    --fl-submenu-color: <?php echo esc_attr($submenu_color); ?>;

		--fl-footer-background: <?php echo esc_attr($footer_bg); ?>;
		--fl-footer-color: <?php echo esc_attr($footer_color); ?>;
		--fl-footer-headings-color: <?php echo esc_attr($footer_headings_color); ?>;
		--fl-copyright-background: <?php echo esc_attr($copyright_bg); ?>;
		--fl-copyright-color: <?php echo esc_attr($copyright_color); ?>;

	    --fl-input-background: #ffffff;

	    --fl-widgets-border-color: rgba(128,128,128,0.1);		    
	    --fl-footer-widgets-border-color: rgba(128,128,128,0.1);		    

	    --fl-overlay-background: rgba(255,255,255,0.7);
	    --fl-overlay-background-hover: rgba(255,255,255,0.95);
	}

	<?php if ( !get_theme_mod('dark_mode') ) { ?>

		[data-theme="dark"] {
		    --fl-body-background: #121212;
		    --fl-blog-background: #1e1e1e;
		    --fl-body-color: #aaaaaa;
		    --fl-headings-color: #ffffff;
		    --fl-meta-color: #777777;		    
		    --fl-button-background: #2c2c2c;
		    --fl-box-background: #222222;
		    --fl-box-color: #ffffff;

		    --fl-header-background: #1e1e1e;
		    --fl-header-color: #ffffff;
		    --fl-submenu-background: #222222;
		    --fl-submenu-color: #ffffff;

		    --fl-footer-background: #222222;
			--fl-footer-color: #aaaaaa;
			--fl-footer-headings-color: #ffffff;
			--fl-copyright-background: #2c2c2c;
			--fl-copyright-color: #ffffff;

		    --fl-input-background: #121212;

		    --fl-widgets-border-color: #252525;
		    --fl-footer-widgets-border-color: #333333;

		    --fl-overlay-background: rgba(30,30,30,0.7);
		    --fl-overlay-background-hover: rgba(30,30,30,0.95);
		}
	<?php }
	 
	$style = ob_get_clean();
    return $style;
}