<?php

// Constants
	define( 'fl_theme_name', 'Tulip' );
	define( 'fl_theme_path', get_template_directory_uri() );
    define( 'fl_theme_version', '2.4' );

// Content Width
if ( ! isset( $content_width ) ) {
    $content_width = 1060;
}

// Setup Theme
function tulip_theme_setup() {

	// Register Main menu
	register_nav_menus(
	  	array( 'main-menu' => esc_html__( 'Main Menu', 'tulip' )
	));
			
	// Feed Links
	add_theme_support( 'automatic-feed-links' );
	
	// Post Formats
	add_theme_support('post-formats', array( 'video', 'audio', 'gallery' ) );

	// Post thumbnails
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'tulip_full_thumb', 1060, 600, true );
    add_image_size( 'tulip_medium_thumb', 576, 384, true );
    add_image_size( 'tulip_masonry_thumb', 576, 0, true );

    // Theme localization
    load_theme_textdomain( 'tulip', get_template_directory() . '/languages' );

    // Title Tag
    add_theme_support( 'title-tag' );
    // Widgets
    add_theme_support( 'widgets' );

    // Add support for editor styles.
    add_theme_support( 'editor-styles' );
    add_editor_style( 'css/editor-style.css' );
    //Google Fonts
    add_editor_style( tulip_google_fonts() );
    //Font Awesome
    add_editor_style( 'css/font-awesome.min.css' );

    //RTL Style editor
    if ( is_rtl() ) {
        add_editor_style( 'css/editor-style-rtl.css' );
    }

    add_theme_support( 'widgets-block-editor' );
    add_theme_support( 'customize-selective-refresh-widgets' );

    // Responsive Embeds
    add_theme_support( 'responsive-embeds' );
    // Align Wide & Full
    add_theme_support( 'align-wide' );

    // Woocommerce Support
    add_theme_support('woocommerce');

    // WooCOmmerce Gallery
    if ( class_exists( 'WooCommerce' ) ) {
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );
    }
}
add_action( 'after_setup_theme', 'tulip_theme_setup' );

// Block Dynamic Style
function tulip_block_style() {
    wp_add_inline_style( 'wp-block-editor', tulip_customizer_output() );
}
add_action( 'enqueue_block_editor_assets', 'tulip_block_style' );

// Addons
function tulip_scripts() {
    // Font Awesome
    wp_enqueue_style('font-awesome', fl_theme_path . '/css/font-awesome.min.css', array(), '4.7.0');
    // Owl Carousel CSS
    wp_enqueue_style('owl-carousel', fl_theme_path . '/css/owl.carousel.min.css', array(), '2.3.4');
    // Google Fonts
    wp_enqueue_style( 'tulip-google-fonts', tulip_google_fonts(), array(), null );
    // Main Style
	wp_enqueue_style( 'tulip-style', get_stylesheet_uri() );
    // OWL Carousel JS
    wp_enqueue_script( 'owl-carousel', fl_theme_path . '/js/owl.carousel.min.js', array('jquery'), '2.3.4', true );
    // Fit Vids JS
    wp_enqueue_script( 'fitvids-script', fl_theme_path . '/js/fitvids.js', array('jquery'), '1.1', true );
    // Masonry
    wp_enqueue_script( 'masonry-script', fl_theme_path . '/js/masonry.pkgd.min.js', array('jquery'), '4.2.2', true );
    // Main Script
    wp_enqueue_script( 'tulip-script', fl_theme_path . '/js/tulip.js', array('jquery'), fl_theme_version, true );

    //Customizer output
    wp_add_inline_style( 'tulip-style', tulip_customizer_output() );    

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'tulip_scripts' );



// Sidebar
function tulip_sidebars() {
    register_sidebar( array(
        'name'         => esc_html__( 'Sidebar', 'tulip' ),
        'id'           => 'sidebar',
        'description'  => esc_html__( 'Sidebar.', 'tulip' ),
        'before_widget'=> '<div id="%1$s" class="fl-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="fl-widget-title">',
        'after_title'  => '</h4>',
    ) );

    // Footer Widgets
    register_sidebar( array(
        'name'         => esc_html__( 'Footer Widgets 1', 'tulip' ),
        'id'           => 'footer1',
        'description'  => esc_html__( 'Footer Widgets 1', 'tulip' ),
        'before_widget'=> '<div id="%1$s" class="fl-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="fl-widget-title">',
        'after_title'  => '</h4>',
    ) );

    register_sidebar( array(
        'name'         => esc_html__( 'Footer Widgets 2', 'tulip' ),
        'id'           => 'footer2',
        'description'  => esc_html__( 'Footer Widgets 2', 'tulip' ),
        'before_widget'=> '<div id="%1$s" class="fl-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="fl-widget-title">',
        'after_title'  => '</h4>',
    ) );

    register_sidebar( array(
        'name'         => esc_html__( 'Footer Widgets 3', 'tulip' ),
        'id'           => 'footer3',
        'description'  => esc_html__( 'Footer Widgets 3', 'tulip' ),
        'before_widget'=> '<div id="%1$s" class="fl-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="fl-widget-title">',
        'after_title'  => '</h4>',
    ) );

    // Woocommerce Sidebar
    if ( class_exists( 'WooCommerce' ) ) {
        register_sidebar( array(
            'name'         => esc_html__( 'WooCommerce Sidebar', 'tulip' ),
            'id'           => 'woocommerce_sidebar',
            'description'  => esc_html__( 'WooCommerce Sidebar.', 'tulip' ),
            'before_widget'=> '<div id="%1$s" class="fl-widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h4 class="fl-widget-title">',
            'after_title'  => '</h4>',
        ) );
    }
}
add_action( 'widgets_init', 'tulip_sidebars' );


// Pagination
function tulip_pagination() {
    global $wp_query;

    $big = 999999999; // need an unlikely integer
    if ($wp_query->max_num_pages > 1) { // check if the max number of pages is greater than 1
    ?>
    <div class="fl-pagination fl-flex">
        <?php
            echo paginate_links( array(
                'base'       => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                'format'     => '?paged=%#%',
                'current'    => max( 1, get_query_var('paged') ),
                'total'      => $wp_query->max_num_pages,
                'prev_text'  => '<i class="fa fa-angle-left"></i>'.esc_html__( 'Newer Posts', 'tulip' ),
                'next_text'  => esc_html__( 'Older Posts', 'tulip' ).'<i class="fa fa-angle-right"></i>',
            ) );
            ?>
    </div>
    <?php
    }
}

// Excerpt More
function tulip_excerpt_more( $more ) {
    return '...';
}
add_filter( 'excerpt_more', 'tulip_excerpt_more' );

// Excerpt Length
function tulip_excerpt_length( $length ) {
    return '60';
}
add_filter( 'excerpt_length', 'tulip_excerpt_length' );

// Read More
function tulip_modify_read_more_link() {
    return '<div class="read-more"><a href="' . get_permalink() . '">'. esc_html__( 'Continue Reading', 'tulip' ).'</a></div>';
}
add_filter( 'the_content_more_link', 'tulip_modify_read_more_link' );


// Customizer
include_once( get_template_directory() . '/functions/customizer.php');

// WooCommerce
if ( class_exists( 'WooCommerce' ) ) {
    include_once ( get_template_directory() . '/functions/woocommerce.php' );
}

// Google fonts
function tulip_google_fonts() {

    $body_font = get_theme_mod('body_font', 'Lora');
    $headings_font = get_theme_mod('headings_font', 'Playfair Display');
     
    $font_families = array(
        'family='. str_replace(' ', '+', $body_font) .':ital,wght@0,400;0,700;1,400;1,700',
        'family='. str_replace(' ', '+', $headings_font) .':ital,wght@0,400;0,700;1,400;1,700'
    );

    $fonts_url = 'https://fonts.googleapis.com/css2?'. implode('&', $font_families). '&display=swap';

    return esc_url_raw($fonts_url);
}

// Adding Arrow to Menu
function tulip_main_menu_arrow( $item_output, $item, $depth, $args ){
    //Only add class to 'top level' items on the 'primary' menu.
    if ( 'main-menu' == $args->theme_location ) {
        if ( in_array("menu-item-has-children", $item->classes) ) {
            $item_output .='<span class="arrow"><i class="fa fa-angle-down"></i></span>';
        }
    }
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'tulip_main_menu_arrow', 10, 4);


// Color Mode
function tulip_color_mode() {
    /// Theme Mode in Javascript
    if ( !get_theme_mod( 'dark_mode' ) ) {
        if ( get_theme_mod( 'dark_mode_default' ) ) { ?>
            <script type="text/javascript">
                if ( document.cookie.indexOf('tulip_color_theme=light') === -1 ) {
                    document.cookie = 'tulip_color_theme=dark; path=/; SameSite=None; Secure';
                }
            </script>
        <?php } ?>
        <script type="text/javascript">
            const userPrefersDark = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            if ( document.cookie.indexOf('tulip_color_theme=dark') > -1 || (userPrefersDark && document.cookie.indexOf('tulip_color_theme=light') === -1) ) {
                document.documentElement.setAttribute('data-theme', 'dark');
                document.addEventListener("DOMContentLoaded", function() {
                    document.getElementById('fl-darkmode').checked = true;
                });
            }
        </script>
        <?php
    }
}
add_action('wp_head', 'tulip_color_mode');


// Layout Settings -> used in all Archive pages
function tulip_layout_settings() {
    if ( is_home() ) {
        $layout = get_theme_mod('blog_layout', 'bricks_sidebar'); 
    } elseif ( is_category() ) {
        $layout = get_theme_mod('category_layout', 'post_grid_sidebar');
    } elseif ( is_author() ) {
        $layout = get_theme_mod('author_layout', 'grid_sidebar');
    } elseif ( is_search() ) {
        $layout = get_theme_mod('search_layout', 'grid_sidebar');
    } else {
        $layout = get_theme_mod('archive_layout', 'grid_sidebar');
    }


    switch ($layout) {
        case 'standard':
        case 'bricks':
        case 'bricks_col_3':
        case 'bricks_col_2_3':
        case 'grid':
        case 'grid_col_3':
        case 'post_grid':
        case 'post_grid_col_3':
            $sidebar = false;
            $class = 'fl-full-width';
            break;

        case 'masonry':
        case 'masonry_col_3':
            $sidebar = false;
            $class = 'fl-full-width';
            $masonry = 'fl-masonry';
            break;

        case 'masonry_sidebar':
            $sidebar = true;
            $masonry = 'fl-masonry';
            break;
        
        default:
            $sidebar = true;
            $class = '';
            $masonry = '';
            break;
    }

    return array(
        'class'   => $class,
        'sidebar' => $sidebar,
        'masonry' => $masonry,
        'layout'  => $layout
    );
}



// TGM Class
require_once ( get_template_directory() . '/functions/class-tgm-plugin-activation.php');

// Required Plugins
function tulip_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name'                  => esc_html__( 'Tulip Theme Addons', 'tulip' ), // The plugin name
            'slug'                  => 'flatlayers-tulip-addons', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/functions/flatlayers-tulip-addons.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     */
    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
    );

    tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'tulip_required_plugins' );