<?php if ( !comments_open() ) {

    if ( have_comments() ) { ?>
        <div id="comments" class="fl-comments">
            <h4 class="widget-title">
                <?php comments_number(esc_html__('No Comments', 'tulip'), esc_html__('1 Comment', 'tulip'), esc_html__( '% Comments', 'tulip') ); ?>
            </h4>

            <ol class="fl-comment-list">
                <?php
                wp_list_comments(
                    array(
                        'avatar_size' => 60,
                        'style'       => 'ol',
                        'short_ping'  => true,
                    )
                );
                ?>
            </ol>

            <?php the_comments_pagination(); ?>

            <p class="fl-no-comments"><?php esc_html_e( 'Comments are closed.', 'tulip' ); ?></p>

        </div>
        
    <?php }

} else { ?>

    <div id="comments" class="fl-comments">
        <h4 class="fl-widget-title">
            <?php comments_number(esc_html__('No Comments', 'tulip'), esc_html__('1 Comment', 'tulip'), esc_html__( '% Comments', 'tulip') ); ?>
        </h4>

        <?php if ( have_comments() ) { ?>
            <ol class="fl-comment-list">
                <?php
                wp_list_comments(
                    array(
                        'avatar_size' => 60,
                        'style'       => 'ol',
                        'short_ping'  => true,
                    )
                );
                ?>
            </ol>

        <?php }

        the_comments_pagination();

        comment_form(
            array(
                'logged_in_as'       => null,
                'title_reply'        => esc_html__( 'Leave a comment', 'tulip' ),
                'title_reply_before' => '<h4 id="fl-reply-title">',
                'title_reply_after'  => '</h4>',
            )
        ); ?>

    </div>

<?php } ?>