<?php

// Tulip Child Theme Styles
function tulip_child_enqueue_styles() {
    $parenthandle = 'tulip-style';
    $theme = wp_get_theme();
    wp_enqueue_style( $parenthandle, get_template_directory_uri() . '/style.css', array(), $theme->parent()->get('Version') );
    wp_enqueue_style( 'tulip-child-style', get_stylesheet_uri(), array( $parenthandle ), $theme->get('Version') );

    //RTL
    if ( is_rtl() ) {
        wp_enqueue_style( 'tulip-rtl-style', get_template_directory_uri() . '/rtl.css', array(), $theme->parent()->get('Version') );
    }
}
add_action( 'wp_enqueue_scripts', 'tulip_child_enqueue_styles' );

// Tulip Child After Setup
function tulip_child_theme_setup() {
    load_child_theme_textdomain( 'tulip-child', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'tulip_child_theme_setup' );