<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

$options = katha_get_theme_options();
$readmore = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Continue reading', 'katha' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if ( has_post_thumbnail() ) : ?>
        <div class="featured-post-image">
            <a href="<?php the_permalink(); ?>">
                <div class="featured-image" style="background-image: url('<?php echo esc_url( get_the_post_thumbnail_url( '', 'medium_large' ) ); ?>');">
                </div><!-- .featured-image -->
            </a>
        </div><!-- .featured-post-image -->
    <?php endif; ?>

    <div class="entry-container">
        <div class="entry-meta">
            <?php katha_article_categories_meta(); ?>
        </div><!-- .entry-meta -->

        <header class="entry-header">
            <h2 class="entry-title"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
            <?php 
            katha_posted_on(); 
            katha_article_comment();
            ?> 
        </header>

        <div class="entry-content">
            <?php the_excerpt(); ?>
        </div><!-- .entry-content -->

        <a href="<?php the_permalink(); ?>" class="btn btn-black"><?php echo esc_html( $readmore ) . katha_get_svg( array( 'icon' => 'right' ) ); ?></a>
    </div><!-- .entry-container -->
</article><!-- #post-## -->
