<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

get_header(); 

while ( have_posts() ) : the_post(); ?>
	<div class="page-detail">
	    <div class="wrapper">
	        <?php katha_single_categories(); ?>

	        <header class="entry-header">
	            <h2 class="entry-title"><?php the_title(); ?></h2>
	        </header>
	        <?php  
	        /**
			 * katha_breadcrumb_action hook
			 *
			 * @hooked katha_add_breadcrumb -  10
			 *
			 */
			do_action( 'katha_breadcrumb_action' );
	        ?>
	    </div><!-- .wrapper -->
	</div>
<?php endwhile; ?>

<div id="inner-content-wrapper" class="page-section no-padding-top clear">
	<div class="wrapper">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<div class="single-post-wrapper">
					<?php
					while ( have_posts() ) : the_post();

						get_template_part( 'template-parts/content', 'single' );

						/**
						* Hook katha_action_post_pagination
						*  
						* @hooked katha_post_pagination 
						*/
						do_action( 'katha_action_post_pagination' );

						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div><!-- .single-post-wrapper -->
			</main><!-- #main -->
		</div><!-- #primary -->

		<?php  
		if ( katha_is_sidebar_enable() ) {
			get_sidebar();
		}
		?>
	</div><!-- .wrapper -->
</div><!-- .page-section -->
<?php
get_footer();
