<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

get_header(); 
?>

<div class="page-detail">
    <div class="wrapper">
        <header class="page-header">
            <h2 class="page-title"><?php printf( esc_html__( 'Search Results for: %s', 'katha' ), get_search_query() ); ?></h2>
        </header><!-- .page-header -->

        <?php  
        /**
		 * katha_breadcrumb_action hook
		 *
		 * @hooked katha_add_breadcrumb -  10
		 *
		 */
		do_action( 'katha_breadcrumb_action' );
        ?>
    </div><!-- .wrapper -->
</div><!-- .page-header -->

<div id="inner-content-wrapper" class="page-section clear no-padding-top">
	<div class="wrapper">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<div class="blog-archive-wrapper">
					<?php
					if ( have_posts() ) : ?>

						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post();

							/*
							 * Include the Post-Format-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_format() );

						endwhile;

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif; ?>
				</div>
				<?php  
				/**
				* Hook - katha_action_pagination.
				*
				* @hooked katha_pagination 
				*/
				do_action( 'katha_action_pagination' ); 
				?>
			</main><!-- #main -->
		</div><!-- #primary -->

		<?php  
		if ( katha_is_sidebar_enable() ) {
			get_sidebar();
		}
		?>
	</div><!-- .wrapper -->
</div><!-- .page-section -->

<?php
get_footer();
