<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

get_header(); 
if ( true === apply_filters( 'katha_filter_frontpage_content_enable', true ) ) : 
	 ?>
	<div class="page-detail">
	    <div class="wrapper">
	        <header class="entry-header">
	            <h2 class="entry-title"><?php single_post_title(); ?></h2>
	        </header>
	        <?php  
	        /**
			 * katha_breadcrumb_action hook
			 *
			 * @hooked katha_add_breadcrumb -  10
			 *
			 */
			do_action( 'katha_breadcrumb_action' );
	        ?>
	    </div><!-- .wrapper -->
	</div>

	<div id="inner-content-wrapper" class="page-section no-padding-top clear">
		<div class="wrapper">
			<div id="primary" class="content-area">
				<main id="main" class="site-main" role="main">
					<div class="single-post-wrapper">
						<?php
						while ( have_posts() ) : the_post();

							get_template_part( 'template-parts/content', 'page' );

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;

						endwhile; // End of the loop.
						?>
						</div><!-- .single-post-wrapper -->
				</main><!-- #main -->
			</div><!-- #primary -->
			<?php
			if ( katha_is_sidebar_enable() ) {
				get_sidebar();
			} ?>
		</div><!-- .wrapper -->
	</div><!-- .page-section -->
<?php endif;
get_footer();
