<?php
/**
 * Theme Palace basic theme structure hooks
 *
 * This file contains structural hooks.
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

$options = katha_get_theme_options();


if ( ! function_exists( 'katha_doctype' ) ) :
	/**
	 * Doctype Declaration.
	 *
	 * @since Katha 1.0.0
	 */
	function katha_doctype() {
	?>
		<!DOCTYPE html>
			<html <?php language_attributes(); ?>>
	<?php
	}
endif;

add_action( 'katha_doctype', 'katha_doctype', 10 );


if ( ! function_exists( 'katha_head' ) ) :
	/**
	 * Header Codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
			<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php endif;
	}
endif;
add_action( 'katha_before_wp_head', 'katha_head', 10 );

if ( ! function_exists( 'katha_page_start' ) ) :
	/**
	 * Page starts html codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_page_start() {
		?>
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'katha' ); ?></a>

		<?php
	}
endif;
add_action( 'katha_page_start_action', 'katha_page_start', 10 );

if ( ! function_exists( 'katha_top_menu' ) ) :
	/**
	 * Top menu html codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_top_menu() {
		$options = katha_get_theme_options();
		if ( ! $options['topbar_social_enable'] )
			return;
		?>
		<div id="top-navigation">
			<div class="social-icons">
				<?php  
					$defaults = array(
						'theme_location' => 'social',
						'container' => 'div',
						'menu_class' => 'menu',
						'echo' => true,
						'fallback_cb' => 'katha_menu_fallback_cb',
						'depth' => 1,
						'link_before' => '<span class="screen-reader-text">',
						'link_after' => '</span>',
					);

					wp_nav_menu( $defaults );
				?>
			</div><!-- .social-icons -->
        </div><!-- .top-navigation -->

		<?php
	}
endif;
add_action( 'katha_page_start_action', 'katha_top_menu', 30 );

if ( ! function_exists( 'katha_page_end' ) ) :
	/**
	 * Page end html codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_page_end() {
		?>
		</div><!-- #page -->
		<?php
	}
endif;
add_action( 'katha_page_end_action', 'katha_page_end', 10 );

if ( ! function_exists( 'katha_header_start' ) ) :
	/**
	 * Header start html codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_header_start() {
		$options = katha_get_theme_options();
		$sticky = ( true === $options['menu_sticky'] ) ? 'sticky-header' : '';
		?>
		<header id="masthead" class="site-header <?php echo esc_attr( $sticky ); ?>" role="banner">
			<div class="wrapper clear">
		<?php
	}
endif;
add_action( 'katha_header_action', 'katha_header_start', 10 );

if ( ! function_exists( 'katha_site_branding' ) ) :
	/**
	 * Site branding codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_site_branding() {
		$options  = katha_get_theme_options();
		$header_txt_logo_extra = $options['header_txt_logo_extra'];		
		?>
		<div class="site-branding">
			<?php if ( in_array( $header_txt_logo_extra, array( 'show-all', 'logo-title', 'logo-tagline' ) )  ) { ?>
				<div class="site-logo">
					<?php the_custom_logo(); ?>
				</div>
			<?php } 
			if ( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title', 'show-all', 'tagline-only', 'logo-tagline' ) ) ) : ?>
				<div id="site-details">
					<?php
					if( in_array( $header_txt_logo_extra, array( 'show-all', 'title-only', 'logo-title' ) )  ) {
						if ( katha_is_latest_posts() ) : ?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php else : ?>
							<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php
						endif;
					} 
					if ( in_array( $header_txt_logo_extra, array( 'show-all', 'tagline-only', 'logo-tagline' ) ) ) {
						$description = get_bloginfo( 'description', 'display' );
						if ( $description || is_customize_preview() ) : ?>
							<p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
						<?php
						endif; 
					}?>
				</div>
			<?php endif; ?>
		</div><!-- .site-branding -->
		<?php
	}
endif;
add_action( 'katha_header_action', 'katha_site_branding', 20 );

if ( ! function_exists( 'katha_site_navigation' ) ) :
	/**
	 * Site navigation codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_site_navigation() {
		$options = katha_get_theme_options();
		?>
		<nav id="site-navigation" class="main-navigation" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>

			<?php  
				$search = '';
				if ( $options['nav_search_enable'] ) :
					$search = '<li class="search-menu"><a class="search" href="#.">';
					$search .= katha_get_svg( array( 'icon' => 'search', 'class' => 'show-search' ) );
					$search .= katha_get_svg( array( 'icon' => 'close', 'class' => 'close-search' ) );
					$search .= '</a><div id="search">';
					$search .= get_search_form( $echo = false );
	                $search .= '</div><!-- #search --></li>';
                endif;

        		$defaults = array(
        			'theme_location' => 'primary',
        			'container' => 'div',
        			'menu_class' => 'menu nav-menu',
        			'menu_id' => 'primary-menu',
        			'echo' => true,
        			'fallback_cb' => 'katha_menu_fallback_cb',
        			'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s' . $search . '</ul>',
        		);
        	
        		wp_nav_menu( $defaults );
        	?>
		</nav><!-- #site-navigation -->
		<?php
	}
endif;
add_action( 'katha_header_action', 'katha_site_navigation', 30 );


if ( ! function_exists( 'katha_header_end' ) ) :
	/**
	 * Header end html codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_header_end() {
		?>
			</div><!-- .wrapper -->
		</header><!-- #masthead -->
		<?php
	}
endif;

add_action( 'katha_header_action', 'katha_header_end', 50 );

if ( ! function_exists( 'katha_content_start' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_content_start() {
		?>
		<div id="content" class="site-content">
		<?php
	}
endif;
add_action( 'katha_content_start_action', 'katha_content_start', 10 );

if ( ! function_exists( 'katha_add_breadcrumb' ) ) :
	/**
	 * Add breadcrumb.
	 *
	 * @since Katha 1.0.0
	 */
	function katha_add_breadcrumb() {
		$options = katha_get_theme_options();
		// Bail if Breadcrumb disabled.
		$breadcrumb = $options['breadcrumb_enable'];
		if ( false === $breadcrumb ) {
			return;
		}
		
		// Bail if Home Page.
		if ( katha_is_frontpage() ) {
			return;
		}

		echo '<div id="breadcrumb-list" >
			<div class="wrapper">';
				/**
				 * katha_simple_breadcrumb hook
				 *
				 * @hooked katha_simple_breadcrumb -  10
				 *
				 */
				do_action( 'katha_simple_breadcrumb' );
		echo '</div>
			</div><!-- #breadcrumb-list -->';
		return;
	}
endif;
add_action( 'katha_breadcrumb_action', 'katha_add_breadcrumb', 20 );

if ( ! function_exists( 'katha_content_end' ) ) :
	/**
	 * Site content codes
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_content_end() {
		?>
			<div class="menu-overlay"></div>
		</div><!-- #content -->
		<?php
	}
endif;
add_action( 'katha_content_end_action', 'katha_content_end', 10 );

if ( ! function_exists( 'katha_footer_start' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_footer_start() {
		?>
		<footer id="colophon" class="site-footer" role="contentinfo">
		<?php
	}
endif;
add_action( 'katha_footer', 'katha_footer_start', 10 );

if ( ! function_exists( 'katha_footer_site_info' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_footer_site_info() {
		$theme_data = wp_get_theme();
		$options = katha_get_theme_options();
		$search = array( '[the-year]', '[site-link]' );

        $replace = array( date( 'Y' ), '<a href="'. esc_url( home_url( '/' ) ) .'">'. esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a>' );

        $copyright_text	 = str_replace( $search, $replace, $options['copyright_text'] );
		$powered_by_text = esc_html__( 'All Rights Reserved | ', 'katha' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'katha' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>';

		?>
		<div class="site-info">
                <div class="wrapper">
                	<?php if ( has_nav_menu( 'social' ) ) : ?>
	                	<div class="social-menu">
		                	<div class="social-icons">
								<?php  
									$defaults = array(
										'theme_location' => 'social',
										'container' => false,
										'menu_class' => 'menu',
										'echo' => true,
										'fallback_cb' => false,
										'depth' => 1,
										'link_before' => '<span class="screen-reader-text">',
										'link_after' => '</span>',
									);

									wp_nav_menu( $defaults );
								?>
							</div><!-- .social-icons -->
						</div><!-- .social-menu -->
					<?php endif; ?>

                	<div class="footer-copyright">
	                    <span><?php echo katha_santize_allow_tag( $copyright_text ); ?></span>
	                    <span><?php echo katha_santize_allow_tag( $powered_by_text ); ?></span>
	                    <?php if ( function_exists( 'the_privacy_policy_link' ) ) {
							the_privacy_policy_link( '<span> | </span>' );
						} ?>
                    </div>
                </div><!-- .wrapper -->    
            </div><!-- .site-info -->

		<?php
	}
endif;
add_action( 'katha_footer', 'katha_footer_site_info', 40 );

if ( ! function_exists( 'katha_footer_scroll_to_top' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_footer_scroll_to_top() {
		$options  = katha_get_theme_options();
		if ( true === $options['scroll_top_visible'] ) : ?>
			<div class="backtotop"><?php echo katha_get_svg( array( 'icon' => 'up' ) ); ?></div>
		<?php endif;
	}
endif;
add_action( 'katha_footer', 'katha_footer_scroll_to_top', 40 );

if ( ! function_exists( 'katha_footer_end' ) ) :
	/**
	 * Footer starts
	 *
	 * @since Katha 1.0.0
	 *
	 */
	function katha_footer_end() {
		?>
		</footer>
		<div class="popup-overlay"></div>
		<?php
	}
endif;
add_action( 'katha_footer', 'katha_footer_end', 100 );
