<?php
/**
 * Portfolio section
 *
 * This is the template for the content of portfolio section
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */
if ( ! function_exists( 'katha_add_portfolio_section' ) ) :
    /**
    * Add portfolio section
    *
    *@since Katha 1.0.0
    */
    function katha_add_portfolio_section() {
    	$options = katha_get_theme_options();
        // Check if portfolio is enabled on frontpage
        $portfolio_enable = apply_filters( 'katha_section_status', true, 'portfolio_section_enable' );

        if ( true !== $portfolio_enable ) {
            return false;
        }
        // Get portfolio section details
        $section_details = array();
        $section_details = apply_filters( 'katha_filter_portfolio_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render portfolio section now.
        katha_render_portfolio_section( $section_details );
    }
endif;
add_action( 'katha_primary_content', 'katha_add_portfolio_section', 40 );

if ( ! function_exists( 'katha_get_portfolio_section_details' ) ) :
    /**
    * portfolio section details.
    *
    * @since Katha 1.0.0
    * @param array $input portfolio section details.
    */
    function katha_get_portfolio_section_details( $input ) {
        $options = katha_get_theme_options();
        
        $content = array();
        $cat_id = ! empty( $options['portfolio_content_category'] ) ? $options['portfolio_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => 4,
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
            );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        $i = 0;
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-400x250.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
                $i++;
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// portfolio section content details.
add_filter( 'katha_filter_portfolio_section_details', 'katha_get_portfolio_section_details' );


if ( ! function_exists( 'katha_render_portfolio_section' ) ) :
  /**
   * Start portfolio section
   *
   * @return string portfolio content
   * @since Katha 1.0.0
   *
   */
   function katha_render_portfolio_section( $content_details = array() ) {
        $options = katha_get_theme_options();
        $portfolio_title  = ! empty( $options['portfolio_title'] ) ? $options['portfolio_title'] : '';

        if ( empty( $content_details ) ) {
            return;
        } 

        $portfolio_count = count( $content_details );
        ?>
        <div id="our-stories" class="page-section">
                <?php if ( ! empty( $portfolio_title ) ) : ?>
                    <header class="entry-header">
                        <h2 class="entry-title"><?php echo esc_html( $portfolio_title ); ?></h2>
                    </header><!-- entry-header -->
                <?php endif; ?>

                <div class="overlay"></div>
                <div class="entry-content <?php echo ( $portfolio_count > 4 ) ? 'center-mode' : 'col-' . absint( $portfolio_count ); ?>">
                    <div class="regular" data-slick='{"slidesToShow": <?php echo ( $portfolio_count < 4 ) ? absint( $portfolio_count ) : 4; ?>, "slidesToScroll": 1, "infinite": true, "speed": 300, "dots": true, "arrows":true, "autoplay": true, "fade": false, "draggable": true }'>
                        <?php foreach ( $content_details as $content ) : ?>
                            <div class="slick-item" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <div class="slick-item-wrapper">
                                    <div class="slide-title">
                                        <span><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></span>
                                        
                                        <time><?php echo date_i18n( get_option( 'date_format' ), strtotime( get_the_date( '', $content['id'] ) ) ); ?></time>
                                    </div><!-- .slide-title -->
                                </div><!-- .slick-item-wrapper -->
                            </div><!-- .slick-item -->
                        <?php endforeach; ?>
                    </div><!-- .regular -->
                </div><!-- .entry-content -->
            </div><!-- #our-stories -->
        <?php 
    }
endif;