<?php
/**
 * Featured section
 *
 * This is the template for the content of featured section
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */
if ( ! function_exists( 'katha_add_featured_section' ) ) :
    /**
    * Add featured section
    *
    *@since Katha 1.0.0
    */
    function katha_add_featured_section() {
    	$options = katha_get_theme_options();
        // Check if featured is enabled on frontpage
        $featured_enable = apply_filters( 'katha_section_status', true, 'featured_section_enable' );

        if ( true !== $featured_enable ) {
            return false;
        }
        // Get featured section details
        $section_details = array();
        $section_details = apply_filters( 'katha_filter_featured_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render featured section now.
        katha_render_featured_section( $section_details );
    }
endif;
add_action( 'katha_primary_content', 'katha_add_featured_section', 10 );

if ( ! function_exists( 'katha_get_featured_section_details' ) ) :
    /**
    * featured section details.
    *
    * @since Katha 1.0.0
    * @param array $input featured section details.
    */
    function katha_get_featured_section_details( $input ) {
        $options = katha_get_theme_options();
        
        $content = array();
        $page_ids = array();

        for ( $i = 1; $i <= 3; $i++ ) {
            if ( ! empty( $options['featured_content_page_' . $i] ) )
                $page_ids[] = $options['featured_content_page_' . $i];
        }
        
        $args = array(
            'post_type'         => 'page',
            'post__in'          => ( array ) $page_ids,
            'posts_per_page'    => 3,
            'orderby'           => 'post__in',
            );                     

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-587x775.jpg';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// featured section content details.
add_filter( 'katha_filter_featured_section_details', 'katha_get_featured_section_details' );


if ( ! function_exists( 'katha_render_featured_section' ) ) :
  /**
   * Start featured section
   *
   * @return string featured content
   * @since Katha 1.0.0
   *
   */
   function katha_render_featured_section( $content_details = array() ) {
        $options = katha_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } 

        $featured_count = count( $content_details );
        ?>
        <div id="featured-post">
               <div class="wrapper col-<?php echo absint( $featured_count ); ?> clear">
                    <?php foreach ( $content_details as $content ) : ?>
                        <article class="hentry">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header><!-- .entry-header -->
                                </div><!-- .entry-container -->
                            </div><!-- .featured-image -->
                            <div class="entry-container">
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                </header><!-- .entry-header -->
                           </div><!-- .entry-container -->
                        </article><!-- .article -->
                    <?php endforeach; ?>
               </div><!-- .wrapper -->
           </div><!-- #featured-post -->
        <?php 
    }
endif;