<?php
/**
 * Blog section
 *
 * This is the template for the content of blog section
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */
if ( ! function_exists( 'katha_add_blog_section' ) ) :
    /**
    * Add blog section
    *
    *@since Katha 1.0.0
    */
    function katha_add_blog_section() {
    	$options = katha_get_theme_options();
        // Check if blog is enabled on frontpage
        $blog_enable = apply_filters( 'katha_section_status', true, 'blog_section_enable' );

        if ( true !== $blog_enable ) {
            return false;
        }
        // Get blog section details
        $section_details = array();
        $section_details = apply_filters( 'katha_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render blog section now.
        katha_render_blog_section( $section_details );
    }
endif;
add_action( 'katha_primary_content', 'katha_add_blog_section', 30 );

if ( ! function_exists( 'katha_get_blog_section_details' ) ) :
    /**
    * blog section details.
    *
    * @since Katha 1.0.0
    * @param array $input blog section details.
    */
    function katha_get_blog_section_details( $input ) {
        $options = katha_get_theme_options();

        $content = array();
        $cat_id = ! empty( $options['blog_content_category'] ) ? $options['blog_content_category'] : '';
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => 4,
            'cat'               => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
            );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = katha_trim_content( 35 );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'katha_filter_blog_section_details', 'katha_get_blog_section_details' );


if ( ! function_exists( 'katha_render_blog_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Katha 1.0.0
   *
   */
   function katha_render_blog_section( $content_details = array() ) {
        $options = katha_get_theme_options();
        $readmore = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Continue Reading', 'katha' );

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="latest-post" class="page-section no-padding-bottom clear">
                <div class="wrapper">
                    <div class="blog-posts-wrapper">
                        <?php foreach ( $content_details as $content ) : ?>
                            <article class="hentry <?php echo ! empty( $content['image'] ) ? 'has-post-thumbnail' : 'no-post-thumbnail'; ?>">
                                <?php if ( ! empty( $content['image'] ) ) : ?>
                                    <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                    </div><!-- .featured-image -->
                                <?php endif; ?>

                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                    </header>
                                    <div class="entry-content">
                                       <?php echo esc_html( $content['excerpt'] ); ?>
                                    </div><!-- .entry-content -->

                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-black"><?php echo esc_html( $readmore ) . katha_get_svg( array( 'icon' => 'right' ) ); ?></a>
                                </div><!-- .entry-container -->
                            </article><!-- .slick-item -->
                        <?php endforeach; ?>
                    </div><!-- .blog-posts-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- #latest-projects -->

    <?php }
endif;