<?php
/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */
if ( ! function_exists( 'katha_add_about_section' ) ) :
    /**
    * Add about section
    *
    *@since Katha 1.0.0
    */
    function katha_add_about_section() {
    	$options = katha_get_theme_options();
        // Check if about is enabled on frontpage
        $about_enable = apply_filters( 'katha_section_status', true, 'about_section_enable' );

        if ( true !== $about_enable ) {
            return false;
        }
        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'katha_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about section now.
        katha_render_about_section( $section_details );
    }
endif;
add_action( 'katha_primary_content', 'katha_add_about_section', 20 );

if ( ! function_exists( 'katha_get_about_section_details' ) ) :
    /**
    * about section details.
    *
    * @since Katha 1.0.0
    * @param array $input about section details.
    */
    function katha_get_about_section_details( $input ) {
        $options = katha_get_theme_options();
        
        $content = array();
        $page_id = ! empty( $options['about_content_page'] ) ? $options['about_content_page'] : '';

        if ( empty( $page_id ) )
            return $input;
        
        $args = array(
            'post_type'         => 'page',
            'page_id'           => $page_id,
            'posts_per_page'    => 1,
            );                     

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']  	= katha_trim_content( 50 );
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about section content details.
add_filter( 'katha_filter_about_section_details', 'katha_get_about_section_details' );


if ( ! function_exists( 'katha_render_about_section' ) ) :
  /**
   * Start about section
   *
   * @return string about content
   * @since Katha 1.0.0
   *
   */
   function katha_render_about_section( $content_details = array() ) {
        $options = katha_get_theme_options();
        $about_btn_label  = ! empty( $options['about_btn_label'] ) ? $options['about_btn_label'] : esc_html__( 'Explore Katha', 'katha' );

        if ( empty( $content_details ) ) {
            return;
        } 

        foreach ( $content_details as $content ) :
        ?>
        <div id="about-us" class="page-section col-2 clear">
                <div class="wrapper">
                    <div class="entry-container">
                        <div class="hentry">
                           <header class="entry-header">
                               <h2 class="entry-title"><?php echo esc_html( $content['title'] ); ?></h2>
                               <div class="seperator"></div>
                           </header>
                        </div><!-- .hentry -->

                        <div class="hentry">
                            <div class="entry-content">
                                <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>

                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-white"><?php echo esc_html( $about_btn_label ) . katha_get_svg( array( 'icon' => 'right' ) ); ?></a>
                            </div><!-- .entry-content -->
                        </div><!-- .hentry -->
                    </div><!-- .entry-container -->
                </div><!-- .wrapper -->
            </div><!-- #about-us -->
        <?php 
        endforeach;
    }
endif;