<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function katha_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'katha' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function katha_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'katha' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

if ( ! function_exists( 'katha_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function katha_site_layout() {
        $katha_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed' => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'katha_site_layout', $katha_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'katha_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function katha_selected_sidebar() {
        $katha_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'katha' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar', 'katha' ),
        );

        $output = apply_filters( 'katha_selected_sidebar', $katha_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'katha_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function katha_sidebar_position() {
        $katha_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'katha_sidebar_position', $katha_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'katha_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function katha_pagination_options() {
        $katha_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'katha' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'katha' ),
        );

        $output = apply_filters( 'katha_pagination_options', $katha_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'katha_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function katha_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'katha' ),
            'off'       => esc_html__( 'Disable', 'katha' )
        );
        return apply_filters( 'katha_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'katha_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function katha_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'katha' ),
            'off'       => esc_html__( 'No', 'katha' )
        );
        return apply_filters( 'katha_hide_options', $arr );
    }
endif;

