<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'katha_single_post_section', array(
	'title'             => esc_html__( 'Single Post','katha' ),
	'description'       => esc_html__( 'Options to change the single posts globally.', 'katha' ),
	'panel'             => 'katha_theme_options_panel',
) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'katha_theme_options[single_post_hide_date]', array(
	'default'           => $options['single_post_hide_date'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[single_post_hide_date]', array(
	'label'             => esc_html__( 'Hide Date', 'katha' ),
	'section'           => 'katha_single_post_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );

// Archive author meta setting and control.
$wp_customize->add_setting( 'katha_theme_options[single_post_hide_author]', array(
	'default'           => $options['single_post_hide_author'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[single_post_hide_author]', array(
	'label'             => esc_html__( 'Hide Author', 'katha' ),
	'section'           => 'katha_single_post_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'katha_theme_options[single_post_hide_category]', array(
	'default'           => $options['single_post_hide_category'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[single_post_hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'katha' ),
	'section'           => 'katha_single_post_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );

// Archive tag category setting and control.
$wp_customize->add_setting( 'katha_theme_options[single_post_hide_tags]', array(
	'default'           => $options['single_post_hide_tags'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[single_post_hide_tags]', array(
	'label'             => esc_html__( 'Hide Tag', 'katha' ),
	'section'           => 'katha_single_post_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );
