<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'katha_pagination', array(
	'title'               => esc_html__('Pagination','katha'),
	'description'         => esc_html__( 'Blog/Archive Pagination options.', 'katha' ),
	'panel'               => 'katha_theme_options_panel',
) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'katha_theme_options[pagination_enable]', array(
	'sanitize_callback' => 'katha_sanitize_switch_control',
	'default'             => $options['pagination_enable'],
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[pagination_enable]', array(
	'label'               => esc_html__( 'Pagination Enable', 'katha' ),
	'section'             => 'katha_pagination',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// Site layout setting and control.
$wp_customize->add_setting( 'katha_theme_options[pagination_type]', array(
	'sanitize_callback'   => 'katha_sanitize_select',
	'default'             => $options['pagination_type'],
) );

$wp_customize->add_control( 'katha_theme_options[pagination_type]', array(
	'label'               => esc_html__( 'Pagination Type', 'katha' ),
	'section'             => 'katha_pagination',
	'type'                => 'select',
	'choices'			  => katha_pagination_options(),
	'active_callback'	  => 'katha_is_pagination_enable',
) );
