<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'katha_menu', array(
	'title'             => esc_html__('Header Menu','katha'),
	'description'       => esc_html__( 'Header Menu options.', 'katha' ),
	'panel'             => 'nav_menus',
) );

// Menu sticky setting and control.
$wp_customize->add_setting( 'katha_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'katha_sanitize_switch_control',
	'default'           => $options['menu_sticky'],
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[menu_sticky]', array(
	'label'             => esc_html__( 'Make Menu Sticky', 'katha' ),
	'section'           => 'katha_menu',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// search enable setting and control.
$wp_customize->add_setting( 'katha_theme_options[nav_search_enable]', array(
	'sanitize_callback' => 'katha_sanitize_switch_control',
	'default'           => $options['nav_search_enable'],
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[nav_search_enable]', array(
	'label'             => esc_html__( 'Enable search', 'katha' ),
	'section'           => 'katha_menu',
	'on_off_label' 		=> katha_switch_options(),
) ) );
