<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'katha_layout', array(
	'title'               => esc_html__('Layout','katha'),
	'description'         => esc_html__( 'Layout section options.', 'katha' ),
	'panel'               => 'katha_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'katha_theme_options[site_layout]', array(
	'sanitize_callback'   => 'katha_sanitize_select',
	'default'             => $options['site_layout'],
) );

$wp_customize->add_control(  new Katha_Custom_Radio_Image_Control ( $wp_customize, 'katha_theme_options[site_layout]', array(
	'label'               => esc_html__( 'Site Layout', 'katha' ),
	'section'             => 'katha_layout',
	'choices'			  => katha_site_layout(),
) ) );

// Sidebar position setting and control.
$wp_customize->add_setting( 'katha_theme_options[sidebar_position]', array(
	'sanitize_callback'   => 'katha_sanitize_select',
	'default'             => $options['sidebar_position'],
) );

$wp_customize->add_control(  new Katha_Custom_Radio_Image_Control ( $wp_customize, 'katha_theme_options[sidebar_position]', array(
	'label'               => esc_html__( 'Blog/Archive Sidebar Position', 'katha' ),
	'section'             => 'katha_layout',
	'choices'			  => katha_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'katha_theme_options[post_sidebar_position]', array(
	'sanitize_callback'   => 'katha_sanitize_select',
	'default'             => $options['post_sidebar_position'],
) );

$wp_customize->add_control(  new Katha_Custom_Radio_Image_Control ( $wp_customize, 'katha_theme_options[post_sidebar_position]', array(
	'label'               => esc_html__( 'Posts Sidebar Position', 'katha' ),
	'section'             => 'katha_layout',
	'choices'			  => katha_sidebar_position(),
) ) );

// Post sidebar position setting and control.
$wp_customize->add_setting( 'katha_theme_options[page_sidebar_position]', array(
	'sanitize_callback'   => 'katha_sanitize_select',
	'default'             => $options['page_sidebar_position'],
) );

$wp_customize->add_control( new Katha_Custom_Radio_Image_Control( $wp_customize, 'katha_theme_options[page_sidebar_position]', array(
	'label'               => esc_html__( 'Pages Sidebar Position', 'katha' ),
	'section'             => 'katha_layout',
	'choices'			  => katha_sidebar_position(),
) ) );