<?php
/**
 * Footer options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Footer Section
$wp_customize->add_section( 'katha_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer Options', 'katha' ),
		'priority'   			=> 900,
		'panel'      			=> 'katha_theme_options_panel',
	)
);

// footer text
$wp_customize->add_setting( 'katha_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'sanitize_callback'		=> 'katha_santize_allow_tag',
		'transport'				=> 'postMessage',
	)
);
$wp_customize->add_control( 'katha_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'katha' ),
		'section'    			=> 'katha_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'katha_theme_options[copyright_text]', array(
		'selector'            => '.site-info .copyright p',
		'settings'            => 'katha_theme_options[copyright_text]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'katha_copyright_text_partial',
    ) );
}

// scroll top visible
$wp_customize->add_setting( 'katha_theme_options[scroll_top_visible]',
	array(
		'default'       		=> $options['scroll_top_visible'],
		'sanitize_callback' => 'katha_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[scroll_top_visible]',
    array(
		'label'      			=> esc_html__( 'Display Scroll Top Button', 'katha' ),
		'section'    			=> 'katha_section_footer',
		'on_off_label' 		=> katha_switch_options(),
    )
) );