<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

$wp_customize->add_section( 'katha_breadcrumb', array(
	'title'             => esc_html__( 'Breadcrumb','katha' ),
	'description'       => esc_html__( 'Breadcrumb section options.', 'katha' ),
	'panel'             => 'katha_theme_options_panel',
) );

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'katha_theme_options[breadcrumb_enable]', array(
	'sanitize_callback' => 'katha_sanitize_switch_control',
	'default'          	=> $options['breadcrumb_enable'],
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[breadcrumb_enable]', array(
	'label'            	=> esc_html__( 'Enable Breadcrumb', 'katha' ),
	'section'          	=> 'katha_breadcrumb',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'katha_theme_options[breadcrumb_separator]', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'          	=> $options['breadcrumb_separator'],
) );

$wp_customize->add_control( 'katha_theme_options[breadcrumb_separator]', array(
	'label'            	=> esc_html__( 'Separator', 'katha' ),
	'active_callback' 	=> 'katha_is_breadcrumb_enable',
	'section'          	=> 'katha_breadcrumb',
) );
