<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'katha_archive_section', array(
	'title'             => esc_html__( 'Blog/Archive','katha' ),
	'description'       => esc_html__( 'Archive section options.', 'katha' ),
	'panel'             => 'katha_theme_options_panel',
) );

// Your latest posts title setting and control.
$wp_customize->add_setting( 'katha_theme_options[your_latest_posts_title]', array(
	'default'           => $options['your_latest_posts_title'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'katha_theme_options[your_latest_posts_title]', array(
	'label'             => esc_html__( 'Your Latest Posts Title', 'katha' ),
	'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'katha' ),
	'section'           => 'katha_archive_section',
	'type'				=> 'text',
	'active_callback'   => 'katha_is_latest_posts'
) );

// Archive date meta setting and control.
$wp_customize->add_setting( 'katha_theme_options[hide_date]', array(
	'default'           => $options['hide_date'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[hide_date]', array(
	'label'             => esc_html__( 'Hide Date', 'katha' ),
	'section'           => 'katha_archive_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );

// Archive author category setting and control.
$wp_customize->add_setting( 'katha_theme_options[hide_category]', array(
	'default'           => $options['hide_category'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[hide_category]', array(
	'label'             => esc_html__( 'Hide Category', 'katha' ),
	'section'           => 'katha_archive_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );

// Archive comment category setting and control.
$wp_customize->add_setting( 'katha_theme_options[hide_comments]', array(
	'default'           => $options['hide_comments'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[hide_comments]', array(
	'label'             => esc_html__( 'Hide Comment', 'katha' ),
	'section'           => 'katha_archive_section',
	'on_off_label' 		=> katha_hide_options(),
) ) );