<?php
/**
 * Topbar Section options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add Topbar section
$wp_customize->add_section( 'katha_topbar_section', array(
	'title'             => esc_html__( 'Topbar','katha' ),
	'description'       => esc_html__( 'Topbar Section options.', 'katha' ),
	'panel'             => 'katha_front_page_panel',
) );

// top bar menu visible
$wp_customize->add_setting( 'katha_theme_options[topbar_social_enable]',
	array(
		'default'       	=> $options['topbar_social_enable'],
		'sanitize_callback' => 'katha_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[topbar_social_enable]',
    array(
		'label'      		=> esc_html__( 'Display Social Menu', 'katha' ),
		'description'       => sprintf( '%1$s <a class="topbar-menu-trigger" href="#"> %2$s </a> %3$s', esc_html__( 'Note: To show topbar menu.', 'katha' ), esc_html__( 'Click Here', 'katha' ), esc_html__( 'to create menu', 'katha' ) ),
		'section'    		=> 'katha_topbar_section',
		'on_off_label' 		=> katha_switch_options(),
    )
) );
