<?php
/**
 * Portfolio Section options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add Portfolio section
$wp_customize->add_section( 'katha_portfolio_section', array(
	'title'             => esc_html__( 'Portfolio','katha' ),
	'description'       => esc_html__( 'Portfolio Section options.', 'katha' ),
	'panel'             => 'katha_front_page_panel',
) );

// Portfolio content enable control and setting
$wp_customize->add_setting( 'katha_theme_options[portfolio_section_enable]', array(
	'default'			=> 	$options['portfolio_section_enable'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[portfolio_section_enable]', array(
	'label'             => esc_html__( 'Portfolio Section Enable', 'katha' ),
	'section'           => 'katha_portfolio_section',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// portfolio title setting and control
$wp_customize->add_setting( 'katha_theme_options[portfolio_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'katha_theme_options[portfolio_title]', array(
	'label'           	=> esc_html__( 'Title', 'katha' ),
	'section'        	=> 'katha_portfolio_section',
	'active_callback' 	=> 'katha_is_portfolio_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'katha_theme_options[portfolio_title]', array(
		'selector'            => '#our-stories .entry-header .entry-title',
		'settings'            => 'katha_theme_options[portfolio_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'katha_portfolio_title_partial',
    ) );
}

// Add dropdown category setting and control.
$wp_customize->add_setting(  'katha_theme_options[portfolio_content_category]', array(
	'sanitize_callback' => 'katha_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Katha_Dropdown_Taxonomies_Control( $wp_customize,'katha_theme_options[portfolio_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'katha' ),
	'description'      	=> esc_html__( 'Note: Latest four posts will be shown from selected category', 'katha' ),
	'section'           => 'katha_portfolio_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'katha_is_portfolio_section_enable'
) ) );
