<?php
/**
 * Featured Section options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add Featured section
$wp_customize->add_section( 'katha_featured_section', array(
	'title'             => esc_html__( 'Featured','katha' ),
	'description'       => esc_html__( 'Featured Section options.', 'katha' ),
	'panel'             => 'katha_front_page_panel',
) );

// Featured content enable control and setting
$wp_customize->add_setting( 'katha_theme_options[featured_section_enable]', array(
	'default'			=> 	$options['featured_section_enable'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[featured_section_enable]', array(
	'label'             => esc_html__( 'Featured Section Enable', 'katha' ),
	'section'           => 'katha_featured_section',
	'on_off_label' 		=> katha_switch_options(),
) ) );

for ( $i = 1; $i <= 3; $i++ ) {
	// featured pages drop down chooser control and setting
	$wp_customize->add_setting( 'katha_theme_options[featured_content_page_' . $i . ']', array(
		'sanitize_callback' => 'katha_sanitize_page',
	) );

	$wp_customize->add_control( new Katha_Dropdown_Chooser( $wp_customize, 'katha_theme_options[featured_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'katha' ), $i ),
		'section'           => 'katha_featured_section',
		'choices'			=> katha_page_choices(),
		'active_callback'	=> 'katha_is_featured_section_enable',
	) ) );
}
