<?php
/**
 * Blog Section options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add Blog section
$wp_customize->add_section( 'katha_blog_section', array(
	'title'             => esc_html__( 'Blog','katha' ),
	'description'       => esc_html__( 'Blog Section options.', 'katha' ),
	'panel'             => 'katha_front_page_panel',
) );

// Blog content enable control and setting
$wp_customize->add_setting( 'katha_theme_options[blog_section_enable]', array(
	'default'			=> 	$options['blog_section_enable'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[blog_section_enable]', array(
	'label'             => esc_html__( 'Blog Section Enable', 'katha' ),
	'section'           => 'katha_blog_section',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'katha_theme_options[blog_content_category]', array(
	'sanitize_callback' => 'katha_sanitize_single_category',
) ) ;

$wp_customize->add_control( new Katha_Dropdown_Taxonomies_Control( $wp_customize,'katha_theme_options[blog_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'katha' ),
	'description'      	=> esc_html__( 'Note: Latest four posts will be shown from selected category', 'katha' ),
	'section'           => 'katha_blog_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'katha_is_blog_section_enable'
) ) );
