<?php
/**
 * About Section options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

// Add About section
$wp_customize->add_section( 'katha_about_section', array(
	'title'             => esc_html__( 'About Us','katha' ),
	'description'       => esc_html__( 'About Section options.', 'katha' ),
	'panel'             => 'katha_front_page_panel',
) );

// About content enable control and setting
$wp_customize->add_setting( 'katha_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'katha_sanitize_switch_control',
) );

$wp_customize->add_control( new Katha_Switch_Control( $wp_customize, 'katha_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About Section Enable', 'katha' ),
	'section'           => 'katha_about_section',
	'on_off_label' 		=> katha_switch_options(),
) ) );

// about pages drop down chooser control and setting
$wp_customize->add_setting( 'katha_theme_options[about_content_page]', array(
	'sanitize_callback' => 'katha_sanitize_page',
) );

$wp_customize->add_control( new Katha_Dropdown_Chooser( $wp_customize, 'katha_theme_options[about_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'katha' ),
	'section'           => 'katha_about_section',
	'choices'			=> katha_page_choices(),
	'active_callback'	=> 'katha_is_about_section_enable',
) ) );

// about title setting and control
$wp_customize->add_setting( 'katha_theme_options[about_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_btn_label'],
	'transport'			=> 'postMessage',

) );

$wp_customize->add_control( 'katha_theme_options[about_btn_label]', array(
	'label'           	=> esc_html__( 'Button Label', 'katha' ),
	'section'        	=> 'katha_about_section',
	'active_callback' 	=> 'katha_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'katha_theme_options[about_btn_label]', array(
		'selector'            => '#about-us .entry-container .entry-content a.btn',
		'settings'            => 'katha_theme_options[about_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'katha_about_btn_label_partial',
    ) );
}
