<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 * @return array An array of default values
 */

function katha_get_default_theme_options() {
	$katha_default_options = array(
		// Color Options
		'header_title_color'			=> '#ffb72b',
		'header_tagline_color'			=> '#fff',
		'header_txt_logo_extra'			=> 'show-all',
		
		// typography Options
		'theme_typography' 				=> 'default',
		'body_theme_typography' 		=> 'default',
		
		// breadcrumb
		'breadcrumb_enable'				=> true,
		'breadcrumb_separator'			=> '/',
		
		// layout 
		'site_layout'         			=> 'wide',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',
		'menu_sticky'					=> true,
		'nav_search_enable'				=> true,

		// excerpt options
		'long_excerpt_length'           => 25,
		'read_more_text'           		=> esc_html__( 'Continue Reading', 'katha' ),
		
		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'katha' ), '[the-year]', '[site-link]' ),
		'scroll_top_visible'        	=> true,

		// reset options
		'reset_options'      			=> false,
		
		// homepage options
		'enable_frontpage_content' 		=> false,

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'katha' ),
		'hide_date' 					=> false,
		'hide_category'					=> false,
		'hide_comments'					=> false,

		// single post theme options
		'single_post_hide_date' 		=> false,
		'single_post_hide_author'		=> false,
		'single_post_hide_category'		=> false,
		'single_post_hide_tags'			=> false,

		/* Front Page */

		// topbar
		'topbar_social_enable'			=> false,

		// Featured
		'featured_section_enable'		=> false,

		// about
		'about_section_enable'			=> false,
		'about_btn_label'				=> esc_html__( 'Explore Katha', 'katha' ),

		// blog
		'blog_section_enable'			=> false,

		// Featured
		'portfolio_section_enable'		=> false,
		'portfolio_title'				=> esc_html__( 'Stories', 'katha' ),



	);

	$output = apply_filters( 'katha_default_theme_options', $katha_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}