<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

if ( ! function_exists( 'katha_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Katha 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function katha_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'katha_theme_options[loader_enable]' )->value();
	}
endif;

if ( ! function_exists( 'katha_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since Katha 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function katha_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'katha_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'katha_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Katha 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function katha_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'katha_theme_options[pagination_enable]' )->value();
	}
endif;

/**
 * Front Page Active Callbacks
 */

/**
 * Check if featured section is enabled.
 *
 * @since Katha 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function katha_is_featured_section_enable( $control ) {
	return ( $control->manager->get_setting( 'katha_theme_options[featured_section_enable]' )->value() );
}

/**
 * Check if about section is enabled.
 *
 * @since Katha 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function katha_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'katha_theme_options[about_section_enable]' )->value() );
}

/**
 * Check if blog section is enabled.
 *
 * @since Katha 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function katha_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'katha_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if portfolio section is enabled.
 *
 * @since Katha 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function katha_is_portfolio_section_enable( $control ) {
	return ( $control->manager->get_setting( 'katha_theme_options[portfolio_section_enable]' )->value() );
}
