<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage Katha
	 * @since Katha 1.0.0
	 */

	/**
	 * katha_doctype hook
	 *
	 * @hooked katha_doctype -  10
	 *
	 */
	do_action( 'katha_doctype' );

?>
<head>
<?php
	/**
	 * katha_before_wp_head hook
	 *
	 * @hooked katha_head -  10
	 *
	 */
	do_action( 'katha_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>
<?php do_action( 'wp_body_open' ); ?>
<?php
	/**
	 * katha_page_start_action hook
	 *
	 * @hooked katha_page_start -  10
	 *
	 */
	do_action( 'katha_page_start_action' ); 

	/**
	 * katha_loader_action hook
	 *
	 * @hooked katha_loader -  10
	 *
	 */
	do_action( 'katha_before_header' );

	/**
	 * katha_header_action hook
	 *
	 * @hooked katha_header_start -  10
	 * @hooked katha_site_branding -  20
	 * @hooked katha_site_navigation -  30
	 * @hooked katha_header_end -  50
	 *
	 */
	do_action( 'katha_header_action' );

	/**
	 * katha_content_start_action hook
	 *
	 * @hooked katha_content_start -  10
	 *
	 */
	do_action( 'katha_content_start_action' );

    if ( katha_is_frontpage() ) {
    	/**
		 * katha_primary_content hook
		 *
		 * @hooked katha_add_featured_section -  10
		 *
		 */
		do_action( 'katha_primary_content' );
	}