jQuery(document).ready(function($) {

/*------------------------------------------------
            PRELOADER
------------------------------------------------*/

$('#loader').delay(1000).fadeOut('slow');
$('#loader-container').delay(1000 ).fadeOut();



/*------------------------------------------------
            STICKY
------------------------------------------------*/
$(window).scroll(function() {    
    var scroll = $(window).scrollTop();  
    if (scroll > 1) {
        $(".sticky-header.site-header").addClass("nav-shrink");
    }
    else {
         $(".sticky-header.site-header").removeClass("nav-shrink");
    }
});


/*------------------------------------------------
                MAIN-NAVIGATION
------------------------------------------------*/
$('.menu-toggle').click(function(){
    $('.nav-menu').fadeToggle();
    $('.main-navigation').toggleClass('menu-open');
});


/*------------------------------------------------
                SEARCH
------------------------------------------------*/

   $('.main-navigation ul li a.search').click(function(e) {
        e.preventDefault();
        $(this).toggleClass('search-open');
        $('.classic-menu .main-navigation #search').toggle();
        $('.classic-menu .main-navigation .search-field').focus();
    });

    $(document).keyup(function(e) {
        if (e.keyCode === 27) {
            $('.main-navigation .search').removeClass('search-open');
            $('.main-navigation #search').hide();
            $('.main-navigation').removeClass('menu-open');
            $('.main-navigation ul.nav-menu').fadeOut();
        }
    });

    $(document).click(function (e) {
      var container = $("#masthead");
       if (!container.is(e.target) && container.has(e.target).length === 0) {
            $('.main-navigation .search').removeClass('search-open');
            $('.main-navigation #search').hide();
            $('.main-navigation').removeClass('menu-open');
            $('.main-navigation ul.nav-menu').fadeOut();
        }
    });


/*--------------------------------------------------------
                SUB-MENU(BUTTON)
----------------------------------------------------------*/

    $('.main-navigation button.dropdown-toggle').click(function() {
       $(this).toggleClass('active');
        $(this).parent().find('.sub-menu').first().slideToggle();
    });
    

/*--------------------------------------------------------
                SLIDER
----------------------------------------------------------*/

    $('#our-stories .regular').slick({
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 3
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 2
          }
        },
        {
          breakpoint: 640,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1
          }
        }
      ]
    });


/*------------------------------------------------
                POPUP VIDEO
------------------------------------------------*/
    $( ".slick-item .popup-video" ).each(function() {

        $(this).click(function (event) {
            event.preventDefault();
            var id = $(this).data('target');

            $('#our-stories').addClass('active');
            $('#' + id + '.video-popup .widget.widget_media_video').slideDown();
            
        });
    });

    $("#our-stories .overlay").click(function() {
        $(".mejs-controls .mejs-playpause-button.mejs-pause button").trigger("click");
        $('#our-stories').removeClass('active');
        $('#our-stories .widget.widget_media_video').slideUp();
    });

/*------------------------------------------------
                BACK TO TOP
------------------------------------------------*/
    $(window).scroll(function() {
        if ($(this).scrollTop() > 1) {
                $('.backtotop').css({bottom:"25px"});
            } 
            else {
                $('.backtotop').css({bottom:"-100px"});
            }
        });

        $('.backtotop').click(function(){
            $('html, body').animate({scrollTop: '0px'}, 800);
            return false;
    });






/*------------------------------------------------
                END JQUERY
------------------------------------------------*/

});