<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Theme Palace
 * @subpackage Katha
 * @since Katha 1.0.0
 */

get_header(); ?>
<div class="page-detail">
    <div class="wrapper">
        <header class="entry-header">
            <h2 class="entry-title"><?php esc_html_e( 'Oops! That page can\'t be found.', 'katha' ); ?></h2>
        </header>
        <?php  
        /**
		 * katha_breadcrumb_action hook
		 *
		 * @hooked katha_add_breadcrumb -  10
		 *
		 */
		do_action( 'katha_breadcrumb_action' );
        ?>
    </div><!-- .wrapper -->
</div>
<div id="inner-content-wrapper" class="page-section clear">
	<div class="wrapper">
		<div id="primary" class="content-area">
			<main id="main" class="site-main" role="main">
				<div class="single-post-wrapper">
					<section class="error-404 not-found">
						<header class="page-header">
							<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/uploads/404.png' ); ?>" alt="<?php esc_attr_e( '404', 'katha' ); ?>">
						</header><!-- .page-header -->

						<div class="page-content">
							<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'katha' ); ?></p>
							<div class="widget">
								<?php get_search_form(); ?>
							</div>
						</div><!-- .page-content -->
					</section><!-- .error-404 -->
				</div>
			</main><!-- #main -->
		</div><!-- #primary -->
	</div>
</div>
<?php
get_footer();
