<?php

/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license. For more information, see
 * <http://www.doctrine-project.org>.
 */
namespace MailPoetVendor\Doctrine\DBAL\Driver;

use PDO;
/**
 * PDO implementation of the Connection interface.
 * Used by all PDO-based drivers.
 *
 * @since 2.0
 */
class PDOConnection extends \PDO implements \MailPoetVendor\Doctrine\DBAL\Driver\Connection, \MailPoetVendor\Doctrine\DBAL\Driver\ServerInfoAwareConnection
{
    /**
     * @param string      $dsn
     * @param string|null $user
     * @param string|null $password
     * @param array|null  $options
     *
     * @throws PDOException in case of an error.
     */
    public function __construct($dsn, $user = null, $password = null, array $options = null)
    {
        try {
            parent::__construct($dsn, $user, $password, $options);
            $this->setAttribute(\PDO::ATTR_STATEMENT_CLASS, array('MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOStatement', array()));
            $this->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        } catch (\PDOException $exception) {
            throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception);
        }
    }
    /**
     * {@inheritdoc}
     */
    public function exec($statement)
    {
        try {
            return parent::exec($statement);
        } catch (\PDOException $exception) {
            throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception);
        }
    }
    /**
     * {@inheritdoc}
     */
    public function getServerVersion()
    {
        return \PDO::getAttribute(\PDO::ATTR_SERVER_VERSION);
    }
    /**
     * {@inheritdoc}
     */
    public function prepare($prepareString, $driverOptions = array())
    {
        try {
            return parent::prepare($prepareString, $driverOptions);
        } catch (\PDOException $exception) {
            throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception);
        }
    }
    /**
     * {@inheritdoc}
     */
    public function query()
    {
        $args = \func_get_args();
        $argsCount = \count($args);
        try {
            if ($argsCount == 4) {
                return parent::query($args[0], $args[1], $args[2], $args[3]);
            }
            if ($argsCount == 3) {
                return parent::query($args[0], $args[1], $args[2]);
            }
            if ($argsCount == 2) {
                return parent::query($args[0], $args[1]);
            }
            return parent::query($args[0]);
        } catch (\PDOException $exception) {
            throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception);
        }
    }
    /**
     * {@inheritdoc}
     */
    public function quote($input, $type = \PDO::PARAM_STR)
    {
        return parent::quote($input, $type);
    }
    /**
     * {@inheritdoc}
     */
    public function lastInsertId($name = null)
    {
        return parent::lastInsertId($name);
    }
    /**
     * {@inheritdoc}
     */
    public function requiresQueryForServerVersion()
    {
        return \false;
    }
}
