<?php

/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license. For more information, see
 * <http://www.doctrine-project.org>.
 */
namespace MailPoetVendor\Doctrine\Common\Collections\Expr;

/**
 * Comparison of a field with a value by the given operator.
 *
 * @author Benjamin Eberlei <kontakt@beberlei.de>
 * @since  2.3
 */
class Comparison implements \MailPoetVendor\Doctrine\Common\Collections\Expr\Expression
{
    const EQ = '=';
    const NEQ = '<>';
    const LT = '<';
    const LTE = '<=';
    const GT = '>';
    const GTE = '>=';
    const IS = '=';
    // no difference with EQ
    const IN = 'IN';
    const NIN = 'NIN';
    const CONTAINS = 'CONTAINS';
    const MEMBER_OF = 'MEMBER_OF';
    const STARTS_WITH = 'STARTS_WITH';
    const ENDS_WITH = 'ENDS_WITH';
    /**
     * @var string
     */
    private $field;
    /**
     * @var string
     */
    private $op;
    /**
     * @var Value
     */
    private $value;
    /**
     * @param string $field
     * @param string $operator
     * @param mixed  $value
     */
    public function __construct($field, $operator, $value)
    {
        if (!$value instanceof \MailPoetVendor\Doctrine\Common\Collections\Expr\Value) {
            $value = new \MailPoetVendor\Doctrine\Common\Collections\Expr\Value($value);
        }
        $this->field = $field;
        $this->op = $operator;
        $this->value = $value;
    }
    /**
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * @return Value
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * @return string
     */
    public function getOperator()
    {
        return $this->op;
    }
    /**
     * {@inheritDoc}
     */
    public function visit(\MailPoetVendor\Doctrine\Common\Collections\Expr\ExpressionVisitor $visitor)
    {
        return $visitor->walkComparison($this);
    }
}
