<?php
/*
 * FLatLayers Latest Posts Widget
 */

class FL_IDs_Posts extends WP_Widget {
	
	public function __construct() {        
        $widget_ops = array( 'classname' => 'fl-posts-widget ids', 'description' => 'Custom IDs Posts Widget' );
        parent::__construct(
            'FL_IDs_Posts',  // Base ID
            fl_theme_name.' IDs Posts', // Name
            $widget_ops
        );
		
	}
	
	/**
	 * Front-end display of widget
	**/
	public function widget( $args, $instance ) {
		extract($args);

		$title = apply_filters('widget_title', $instance['title']);
		$posts_ids = isset( $instance['posts_ids'] ) ? $instance['posts_ids'] : '';
		$hide_img = isset( $instance['hide_img'] ) ? true : false;

		$Ids = str_replace(' ', '', $posts_ids);

		$array_ids = explode(',',$Ids);

		$loop = new WP_Query(
			array(
				'post_type' => 'post',	
				'post_status' => 'publish',
				'post__in' => $array_ids,
				'ignore_sticky_posts' => 1
				
			)
		);
		
        if ( $loop->have_posts() ) {

			echo ( $args['before_widget'] );

            if (!empty($title) ) {
	            echo ( $args['before_title'] . $title . $args['after_title'] );
	        }

			while ( $loop->have_posts() ) {
            	$loop->the_post();
				?>
				<div class="item fl-flex">
                    <div class="fl-picture">
                        <a href="<?php the_permalink(); ?>">
                		<?php
                    		the_title();
	                    	if ( $hide_img === false && has_post_thumbnail() ) {
	                    		the_post_thumbnail('thumbnail');
	                    	}
                    	?>
                        </a>
                    </div>
		        	<div class="content">		                
		                <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>

		                <span class="fl-meta category"><?php echo the_category(', '); ?></span>

		                <?php if ( !get_theme_mod( 'hide_meta_author' ) ) { ?>
		                <span class="fl-meta"><?php esc_html_e( 'By ', 'flatlayers' ); the_author_posts_link(); ?></span>
		                <?php } ?>

		                <?php if ( !get_theme_mod( 'hide_meta_date' ) ) { ?>
		                <span class="fl-meta"><i class="fa fa-calendar-o"></i><?php echo get_the_date('M d, Y'); ?></span>
		                <?php } ?>
	                </div>
	           	</div>
            <?php }

            echo ( $args['after_widget'] );

			wp_reset_postdata();
		}
		
	}	
	
	/**
     * Back-end widget form.
     */
    public function form( $instance ) {

        $instance = wp_parse_args( (array) $instance, array( 
			'title'      => '',
			'posts_ids'  => '',
			'hide_img' => 'off'
		) );

		?>
		<p>
	        <label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php echo esc_html_e( 'Title:', 'flatlayers' ); ?></label><br>
	        <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
	    </p>
		<p>
	        <label for="<?php echo esc_attr( $this->get_field_id('posts_ids') ); ?>"><?php echo esc_html_e( 'Posts IDs (Split ids by ","):', 'flatlayers' ); ?></label><br>
	        <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('posts_ids') ); ?>" name="<?php echo esc_attr( $this->get_field_name('posts_ids') ); ?>" type="text" value="<?php echo esc_attr( $instance['posts_ids'] ); ?>">
	    </p><p>
	        <input id="<?php echo esc_attr( $this->get_field_id('hide_img') ); ?>" name="<?php echo esc_attr( $this->get_field_name('hide_img') ); ?>" type="checkbox" <?php checked( $instance['hide_img'], 'on' ); ?>> 
	        <label for="<?php echo esc_attr( $this->get_field_id('hide_img') ); ?>"><?php echo esc_html_e( 'Hide Post thumbnail', 'flatlayers' ); ?></label>
	    </p>
		<?php
	}

	/**
     * Sanitize widget form values as they are saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['posts_ids']  = $new_instance['posts_ids'];
        $instance['hide_img']  = $new_instance['hide_img'];

        return $instance;
    }
    
}

// register widget
function register_fl_ids_posts() {
	register_widget( 'FL_IDs_Posts' );
}

add_action('widgets_init', 'register_fl_ids_posts');