<?php
/*
 * FLatLayers About Widget
 */

class FL_About extends WP_Widget {
 
    public function __construct() {        
        $widget_ops = array( 'classname' => 'fl-about', 'description' => 'About Widget' );
        parent::__construct(
            'FL_About',  // Base ID
            fl_theme_name.' About', // Name
            $widget_ops
        );
    }
 
    /**
     * Front-end display of widget.
     */
    public function widget($args, $instance) {
    	extract($args);
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $subtitle = isset( $instance['subtitle'] ) ? $instance['subtitle'] : '';
        $image = isset( $instance['image'] ) ? $instance['image'] : '';
        $desc  = isset( $instance['desc'] ) ? $instance['desc'] : '';
        $signing = isset( $instance['signing'] ) ? $instance['signing'] : '';

        echo ( $args['before_widget'] );
        
            echo '<div class="profile">';
                if ( !empty($image) ) {
                    echo '<img loading="lazy" src="' . esc_url($image) . '" alt="'. esc_attr($title) .'">';
                }
                if (!empty($title) ) {
                    echo '<h3 class="title">'. esc_attr($title) .'</h3>';
                }
            echo '</div>';
            if (!empty($subtitle) ) {
                echo '<span class="fl-meta">'. esc_attr($subtitle) .'</span>';
            }
            if ( !empty($desc) ) {
                echo '<div class="desc">' . wp_kses_post( $desc ) . '</div>';
            }
            if ( !empty($signing) ) {
                echo '<img class="signing" loading="lazy" src="' . esc_url($signing) . '" alt="'. esc_attr($title) .'">';
            }

        echo ( $args['after_widget'] );
    } 

    /**
     * Back-end widget form.
     */
    public function form( $instance ) {
        $instance = wp_parse_args( (array) $instance, array( 
            'title' => '',
            'subtitle' => '',
            'image' => '',
            'desc'  => '',
            'signing'  => ''
            ) );
        ?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php echo esc_html_e( 'Title:', 'flatlayers' ); ?></label><br>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('subtitle') ); ?>"><?php echo esc_html_e( 'Subtitle:', 'flatlayers' ); ?></label><br>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('subtitle') ); ?>" name="<?php echo esc_attr( $this->get_field_name('subtitle') ); ?>" type="text" value="<?php echo esc_attr( $instance['subtitle'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('image') ); ?>"><?php echo esc_html_e( 'Image URL:', 'flatlayers' ); ?></label><br>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('image') ); ?>" name="<?php echo esc_attr( $this->get_field_name('image') ); ?>" type="text" value="<?php echo esc_attr( $instance['image'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('desc') ); ?>"><?php echo esc_html_e( 'Description:', 'flatlayers' ); ?></label><br>
            <textarea class="widefat"  rows="5" cols="20" id="<?php echo esc_attr( $this->get_field_id('desc') ); ?>" name="<?php echo esc_attr( $this->get_field_name('desc') ); ?>"><?php echo esc_attr( $instance['desc'] ); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id('signing') ); ?>"><?php echo esc_html_e( 'Signature Image URL:', 'flatlayers' ); ?></label><br>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('signing') ); ?>" name="<?php echo esc_attr( $this->get_field_name('signing') ); ?>" type="text" value="<?php echo esc_attr( $instance['signing'] ); ?>">
        </p>

        <?php 
    }
 
    /**
     * Sanitize widget form values as they are saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['subtitle'] = $new_instance['subtitle'];
        $instance['image'] = $new_instance['image'];
        $instance['desc']  = $new_instance['desc'];
        $instance['signing']  = $new_instance['signing'];

        return $instance;
    }
    
}

// register widget
function register_fL_about() {
    register_widget('FL_About');
}
add_action('widgets_init', 'register_fL_about');