<?php
/*
Plugin Name: Tulip Theme Addons
Plugin URI: https://flatlayers.com
Description: Tulip theme addons (Post Formats, Widgets, Author Social Profiles).
Version: 1.0
Author: FlatLayers
Author URI: https://flatlayers.com
*/


if (!defined('FL_TULIP_ADDONS_VERSION')) {

	define('FL_TULIP_ADDONS_VERSION', '1.0');

	function fl_tulip_addons_base_url() {
		return trailingslashit(apply_filters('fl_tulip_addons_base_url', plugins_url('', __FILE__)));
	}

	function fl_tulip_addons_init() {
	    load_plugin_textdomain( 'flatlayers', false, fl_tulip_addons_base_url() . '/languages' ); 
	}
	add_action( 'plugins_loaded', 'fl_tulip_addons_init' );

	// Post Formats
	include_once( 'addons/post-formats.php' );

	// User Socials
	include_once( 'addons/user-socials.php' );

	// Widgets
	include_once( 'addons/widgets/latest-posts.php');
	include_once( 'addons/widgets/category-posts.php' );
	include_once( 'addons/widgets/ids-posts.php' );
	include_once( 'addons/widgets/random-posts.php' );
	include_once( 'addons/widgets/about.php');


} // end defined check
