jQuery(function($) {
	'use strict';
	
	// tab switch
	$('#fl-pf-tabs a').click(function(e){
		var href = $(this).attr('href'),
			post_format = href.split('#fl-pf-')[1];

		wp.data.dispatch('core/editor').editPost({ format: post_format });

		e.preventDefault();
	});

	// Format Changes
	wp.data.subscribe( function () {
		var format = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'format' );

		$('.fl-pf-block').removeClass('fl-pf-active');
		$('#fl-pf-'+format).addClass('fl-pf-active');

		$('#fl-pf-tabs a').removeClass('is-primary');
		$('#fl-pf-tabs a[href="#fl-pf-'+format+'"]').addClass('is-primary');
	});


	// Gallery Management
	var gallery = $('.fl-pf-gallery-picker .gallery');

	var FLPFMediaControl = {

		// Init a new media manager or returns existing frame
		frame: function() {
			if( this._frame )
				return this._frame;

			this._frame = wp.media({
				title: fl_tulip_addons.media_title,
				library: {
					type: 'image'
				},
				button: {
					text: fl_tulip_addons.media_button
				},
				multiple: true
			});

			this._frame.on('open', this.updateFrame).state('library').on('select', this.select);

			return this._frame;
		},

		select: function() {
			var selection = this.get('selection');

			selection.each(function(model) {
				var thumbnail = model.attributes.url;
				if( model.attributes.sizes !== undefined && model.attributes.sizes.thumbnail !== undefined )
					thumbnail = model.attributes.sizes.thumbnail.url;
				gallery.append('<span data-id="' + model.id + '" title="' + model.attributes.title + '"><img src="' + thumbnail + '" alt="" /><span class="close">x</span></span>');
				gallery.trigger('update');
			});
		},

		updateFrame: function() {
		},

		init: function() {
			$('#wpbody').on('click', '#fl-pf-gallery-button', function(e){
				e.preventDefault();
				FLPFMediaControl.frame().open();
			});
		}
	}
	
	FLPFMediaControl.init();

	gallery.on('update', function(){
		var ids = [];
		$(this).find('> span').each(function(){
			ids.push($(this).data('id'));
		});
		$('[name="_format_gallery_images"]').val(ids.join(','));
	});

	gallery.sortable({
		placeholder: "fl-pf-ui-state-highlight",
		revert: 200,
		tolerance: 'pointer',
		stop: function () {
			gallery.trigger('update');
		}
	});

	gallery.on('click', 'span.close', function(e){
		$(this).parent().fadeOut(200, function(){
			$(this).remove();
			gallery.trigger('update');
		});
	});

});
