<?php
///////////////////////
// Social Profiles for Users
///////////////////////

// Add/Edit Socials
function fl_social_profiles( $user ) {

	$socials = array(
		'twitter',
		'facebook',
		'instagram',
		'youtube',
		'linkedin',
		'pinterest',
		'vk'
	);

	echo '<h3>Social Profiles</h3>';
	echo '<table class="form-table">';
		foreach ($socials as $social) {
			echo '<tr>';
				echo '<th><label for="'. $social .'">'. ucfirst($social) .'</label></th>';
				echo '<td>';
					echo '<input type="text" name="'. $social .'" id="'. $social .'" value="'. esc_url( get_the_author_meta( $social, $user->ID ) ) .'" class="regular-text"><br>';
					echo '<span class="description">Please, enter your '. ucfirst($social) .' profile url.</span>';
				echo '</td>';
			echo '</tr>';
		}
	echo '</table>';
}
add_action( 'show_user_profile', 'fl_social_profiles' );
add_action( 'edit_user_profile', 'fl_social_profiles' );

function fl_save_social_profiles( $user_id ) {

    if ( !current_user_can( 'edit_user', $user_id ) )
        return false;

    $socials = array(
		'twitter',
		'facebook',
		'instagram',
		'youtube',
		'linkedin',
		'pinterest',
		'vk'
	);


	foreach ($socials as $social) {
		update_user_meta( $user_id, $social, $_POST[$social] );
	}
}
add_action( 'personal_options_update', 'fl_save_social_profiles' );
add_action( 'edit_user_profile_update', 'fl_save_social_profiles' );