<?php
///////////////////////
// Post Formats Metabox
///////////////////////

// Register MetaBox
function fl_pf_add_meta_boxes($post_type) {
	if ( post_type_supports($post_type, 'post-formats') && current_theme_supports('post-formats') ) {
		// assets
		wp_enqueue_script('fl-tulip-addons', fl_tulip_addons_base_url().'assets/script.js', array('jquery'), FL_TULIP_ADDONS_VERSION);
		wp_enqueue_style('fl-tulip-addons', fl_tulip_addons_base_url().'assets/style.css', array(), FL_TULIP_ADDONS_VERSION, 'screen');

		wp_localize_script(
			'fl-tulip-addons',
			'fl_tulip_addons',
			array(
				'loading'      => __('Loading...', 'flatlayers'),
				'wpspin_light' => admin_url('images/wpspin_light.gif'),
				'media_title'  => __('Pick Gallery Images', 'flatlayers'),
				'media_button' => __('Add Image(s)', 'flatlayers')
			)
		);

		add_meta_box(
            'fl_pf_metabox',           
            __('Post Formats', 'flatlayers'),  // Box title
            'fl_pf_html',  // Content callback, must be of type callable
            'post',
	        'normal',
	        'default'
        );
	}
}
add_action('add_meta_boxes', 'fl_pf_add_meta_boxes');

// MetaBox HTML
function fl_pf_html($post) {
	$post_formats = get_theme_support('post-formats');
	array_unshift($post_formats[0], 'standard');
	$post_formats = $post_formats[0];

	if ( !empty($post_formats) && is_array($post_formats) ) {
		$current_post_format = get_post_format($post->ID);

		if (!empty($current_post_format) && !in_array($current_post_format, $post_formats)) {
			array_push($post_formats, $current_post_format);
		}
		

		echo '<ul id="fl-pf-tabs">';
			foreach($post_formats as $format) {
				$class = ($format == $current_post_format || (empty($current_post_format) && $format == 'standard') ? 'is-primary' : '');
				
				$format_string = get_post_format_string($format);
				$format_hash = 'fl-pf-'.$format;
				
				echo '<li><a class="components-button '.esc_attr($class).'" href="#'.esc_attr($format_hash).'">'.esc_html($format_string).'</a></li>';
			}
		echo '</ul>';

		foreach ($post_formats as $format) {
			$class = ($format == $current_post_format || (empty($current_post_format) && $format == 'standard') ? 'fl-pf-active' : '');
			echo '<div id="fl-pf-'.$format.'" class="fl-pf-block '.$class.'">';
			switch ($format) {
				case 'audio':
				case 'video':
						echo '<label for="fl-pf-'.$format.'">'. get_post_format_string($format) . __(' URL (oEmbed) or Embed Code', 'flatlayers'). '</label>';
						echo '<textarea name="_format_'.$format.'_embed" id="fl-pf-'.$format.'">';
							echo esc_textarea( get_post_meta($post->ID, '_format_'.$format.'_embed', true) );
						echo '</textarea>';
						break;

				case 'gallery':
					echo '<label>'. __('Gallery Images', 'flatlayers'). '</label>';
					echo '<div class="fl-pf-gallery-picker">';						
							$images = get_post_meta($post->ID, '_format_gallery_images', true);
							echo '<div class="gallery">';
							if ( !empty($images) ) {
								foreach ($images as $image) {
									$thumbnail = wp_get_attachment_image_src($image, 'thumbnail');
									echo '<span data-id="' . $image . '" title="' . 'title' . '"><img src="' . $thumbnail[0] . '" alt="" /><span class="close">x</span></span>';
								}
							}
							echo '</div>';						
						echo '<input type="hidden" name="_format_gallery_images" value="'. (empty($images) ? "" : implode(',', $images)) .'">';
						echo '<p><button id="fl-pf-gallery-button" class="button">'. __('Pick Gallery Images', 'flatlayers'). '</button></p>';
					echo '</div>';
					break;
				
				default:
					// code...
					break;
			}
			echo '</div>';
		}
	}
}


// Save MetaBox
function fl_pf_save_meta_boxes( $post_id ) {

	// Return if the user doesn't have edit permissions.
	if ( !current_user_can( 'edit_post', $post_id ) ) {
		return $post_id;
	}

	$post_formats = get_theme_support('post-formats');
	array_unshift($post_formats[0], 'standard');
	$post_formats = $post_formats[0];

	foreach ($post_formats as $format) {
		switch ($format) {
			case 'audio':
			case 'video':
				if ( isset($_POST['_format_'.$format.'_embed']) ) {        
					update_post_meta($post_id, '_format_'.$format.'_embed', $_POST['_format_'.$format.'_embed']);
				}
				break;

			case 'gallery':
				if( isset($_POST['_format_gallery_images']) && $_POST['_format_gallery_images'] !== '' ) {
					$images = explode(',', $_POST['_format_gallery_images']);		
				} else {
					$images = array();
				}			
				update_post_meta($post_id, '_format_gallery_images', $images);
				break;

			default:
				// code...
				break;
		}
	}

}
add_action( 'save_post', 'fl_pf_save_meta_boxes' );